/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.patches;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import pw.prok.imagine.asm.ImagineASM;
import pw.prok.imagine.asm.Transformer;

@Transformer.RegisterTransformer
public class StreamsTransformer
implements Transformer {
    public void transform(ImagineASM asm) {
        if (asm.is("streams.world.gen.structure.RiverComponent$")) {
            System.out.println("[Crucible] Found streams.world.gen.structure.RiverComponent$, trying to patch it!");
            InsnList instructions = asm.method("<init>", "()V").instructions();
            AbstractInsnNode toReplace = null;
            for (AbstractInsnNode ins : instructions) {
                if (ins.getOpcode() != 5 || !(ins.getNext() instanceof FieldInsnNode)) continue;
                FieldInsnNode fieldAccess = (FieldInsnNode)ins.getNext();
                if (!fieldAccess.name.contains("MinSourceBackWallHeight")) continue;
                toReplace = fieldAccess.getPrevious();
                break;
            }
            if (toReplace == null) {
                System.out.println("[Crucible] Unable to find MinSourceBackWallHeight, skipping patch!");
            } else {
                instructions.set(toReplace, (AbstractInsnNode)new InsnNode(3));
                System.out.println("[Crucible] Patched MinSourceBackWallHeight's previous opcode!");
            }
        }
    }
}

