/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.util.UUID;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import net.minecraft.server.MinecraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.util.Waitable;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;

class ThreadPlayerLookupUUID
extends Thread {
    final nn field_151292_a;
    private final MinecraftServer mcServer;

    ThreadPlayerLookupUUID(nn p_i45296_1_, String p_i45296_2_) {
        super(p_i45296_2_);
        this.field_151292_a = p_i45296_1_;
        this.mcServer = nn.getMinecraftServer((nn)this.field_151292_a);
    }

    @Override
    public void run() {
        GameProfile gameprofile = nn.getGameProfile((nn)this.field_151292_a);
        try {
            if (!this.mcServer.Y()) {
                this.field_151292_a.initUUID();
                this.fireLoginEvents();
                return;
            }
            String s = new BigInteger(pt.a((String)nn.getLoginServerId((nn)this.field_151292_a), (PublicKey)this.mcServer.K().getPublic(), (SecretKey)nn.getSecretKey((nn)this.field_151292_a))).toString(16);
            GameProfile profile = this.mcServer.av().hasJoinedServer(new GameProfile(null, gameprofile.getName()), s);
            if (profile != null) {
                nn.processPlayerLoginGameProfile((nn)this.field_151292_a, (GameProfile)profile);
                this.fireLoginEvents();
            } else if (this.mcServer.N()) {
                nn.getLogger().warn("Failed to verify username but will let them in anyway!");
                nn.processPlayerLoginGameProfile((nn)this.field_151292_a, (GameProfile)this.field_151292_a.a(gameprofile));
                nn.setLoginState((nn)this.field_151292_a, (np)np.d);
            } else {
                this.field_151292_a.a("Failed to verify username!");
                nn.getLogger().error("Username '" + nn.getGameProfile((nn)this.field_151292_a).getName() + "' tried to join with an invalid session");
            }
        }
        catch (AuthenticationUnavailableException authenticationunavailableexception) {
            if (this.mcServer.N()) {
                nn.getLogger().warn("Authentication servers are down but will let them in anyway!");
                nn.processPlayerLoginGameProfile((nn)this.field_151292_a, (GameProfile)this.field_151292_a.a(gameprofile));
                nn.setLoginState((nn)this.field_151292_a, (np)np.d);
            } else {
                this.field_151292_a.a("Authentication servers are down. Please try again later, sorry!");
                nn.getLogger().error("Couldn't verify username because servers are unavailable");
            }
        }
        catch (Exception exception) {
            this.field_151292_a.a("Failed to verify username!");
            this.mcServer.server.getLogger().log(Level.WARNING, "Exception verifying " + nn.getGameProfile((nn)this.field_151292_a).getName(), exception);
        }
    }

    private void fireLoginEvents() throws Exception {
        if (!this.field_151292_a.a.d()) {
            return;
        }
        String playerName = nn.getGameProfile((nn)this.field_151292_a).getName();
        InetAddress address = ((InetSocketAddress)this.field_151292_a.a.b()).getAddress();
        UUID uniqueId = nn.getGameProfile((nn)this.field_151292_a).getId();
        final CraftServer server = this.mcServer.server;
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
        server.getPluginManager().callEvent(asyncEvent);
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
            }
            Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(){

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    server.getPluginManager().callEvent(event);
                    return event.getResult();
                }
            };
            nn.getMinecraftServer((nn)this.field_151292_a).processQueue.add(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.field_151292_a.a(event.getKickMessage());
                return;
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.field_151292_a.a(asyncEvent.getKickMessage());
            return;
        }
        nn.getLogger().info("UUID of player " + nn.getGameProfile((nn)this.field_151292_a).getName() + " is " + nn.getGameProfile((nn)this.field_151292_a).getId());
        nn.setLoginState((nn)this.field_151292_a, (np)np.d);
    }
}

