/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron.command;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.CauldronHooks;
import net.minecraftforge.cauldron.configuration.BoolSetting;
import net.minecraftforge.cauldron.configuration.IntSetting;
import net.minecraftforge.cauldron.configuration.Setting;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class CauldronCommand
extends Command {
    private static final List<String> COMMANDS = ImmutableList.of((Object)"get", (Object)"set", (Object)"tick-interval", (Object)"save", (Object)"reload", (Object)"chunks", (Object)"heap");
    private static final List<String> CHUNK_COMMANDS = ImmutableList.of((Object)"print", (Object)"dump");
    public static boolean debug = false;

    public CauldronCommand() {
        super("cauldron");
        this.description = "Toggle certain Cauldron options";
        this.usageMessage = "/cauldron [" + StringUtils.join(COMMANDS, (char)'|') + "] <option> [value]";
        this.setPermission("cauldron.command.cauldron");
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length > 0 && "debug".equalsIgnoreCase(args[0])) {
            debug = !debug;
            sender.sendMessage("Robotia says debug is " + debug);
            return true;
        }
        if (args.length > 0 && "heap".equalsIgnoreCase(args[0])) {
            this.processHeap(sender, args);
            return true;
        }
        if (args.length > 0 && "chunks".equalsIgnoreCase(args[0])) {
            this.processChunks(sender, args);
            return true;
        }
        if (args.length == 1 && "save".equalsIgnoreCase(args[0])) {
            MinecraftServer.cauldronConfig.save();
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Config file saved");
            return true;
        }
        if (args.length == 1 && "reload".equalsIgnoreCase(args[0])) {
            MinecraftServer.cauldronConfig.load();
            for (int i = 0; i < MinecraftServer.I().worlds.size(); ++i) {
                ((mt)MinecraftServer.I().worlds.get((int)i)).cauldronConfig.init();
            }
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Config file reloaded");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        if ("tick-interval".equalsIgnoreCase(args[0])) {
            return this.intervalSet(sender, args);
        }
        if ("get".equalsIgnoreCase(args[0])) {
            return this.getToggle(sender, args);
        }
        if ("set".equalsIgnoreCase(args[0])) {
            return this.setToggle(sender, args);
        }
        sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
        return false;
    }

    private void processHeap(CommandSender sender, String[] args) {
        File file = new File(new File(new File("."), "dumps"), "heap-dump-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.bin");
        sender.sendMessage("Writing chunk info to: " + file);
        CauldronHooks.dumpHeap(file, true);
        sender.sendMessage("Chunk info complete");
    }

    private void processChunks(CommandSender sender, String[] args) {
        sender.sendMessage((Object)((Object)ChatColor.GOLD) + "Dimension stats: ");
        for (mt world : MinecraftServer.I().worlds) {
            sender.sendMessage((Object)((Object)ChatColor.GOLD) + "Dimension: " + (Object)((Object)ChatColor.GRAY) + world.t.i + (Object)((Object)ChatColor.GOLD) + " Loaded Chunks: " + (Object)((Object)ChatColor.GRAY) + world.b.loadedChunkHashMap_KC.size() + (Object)((Object)ChatColor.GOLD) + " Active Chunks: " + (Object)((Object)ChatColor.GRAY) + world.F.size() + (Object)((Object)ChatColor.GOLD) + " Entities: " + (Object)((Object)ChatColor.GRAY) + world.e.size() + (Object)((Object)ChatColor.GOLD) + " Tile Entities: " + (Object)((Object)ChatColor.GRAY) + world.g.size());
            sender.sendMessage((Object)((Object)ChatColor.GOLD) + " Entities Last Tick: " + (Object)((Object)ChatColor.GRAY) + world.entitiesTicked + (Object)((Object)ChatColor.GOLD) + " Tiles Last Tick: " + (Object)((Object)ChatColor.GRAY) + world.tilesTicked + (Object)((Object)ChatColor.GOLD) + " Removed Entities: " + (Object)((Object)ChatColor.GRAY) + world.f.size() + (Object)((Object)ChatColor.GOLD) + " Removed Tile Entities: " + (Object)((Object)ChatColor.GRAY) + world.b.size());
        }
        if (args.length < 2 || !"dump".equalsIgnoreCase(args[1])) {
            return;
        }
        boolean dumpAll = args.length > 2 && "all".equalsIgnoreCase(args[2]);
        File file = new File(new File(new File("."), "chunk-dumps"), "chunk-info-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
        sender.sendMessage("Writing chunk info to: " + file);
        CauldronHooks.writeChunks(file, dumpAll);
        sender.sendMessage("Chunk info complete");
    }

    private boolean getToggle(CommandSender sender, String[] args) {
        try {
            Setting toggle = MinecraftServer.cauldronConfig.getSettings().get(args[1]);
            if (toggle == null && MinecraftServer.cauldronConfig.isSet(args[1])) {
                if (MinecraftServer.cauldronConfig.isBoolean(args[1])) {
                    toggle = new BoolSetting(MinecraftServer.cauldronConfig, args[1], MinecraftServer.cauldronConfig.getBoolean(args[1], false), "");
                } else if (MinecraftServer.cauldronConfig.isInt(args[1])) {
                    toggle = new IntSetting(MinecraftServer.cauldronConfig, args[1], MinecraftServer.cauldronConfig.getInt(args[1], 1), "");
                }
                if (toggle != null) {
                    MinecraftServer.cauldronConfig.getSettings().put(toggle.path, toggle);
                    MinecraftServer.cauldronConfig.load();
                }
            }
            if (toggle == null) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Could not find option: " + args[1]);
                return false;
            }
            Object value = toggle.getValue();
            String option = (Object)((Object)(Boolean.TRUE.equals(value) ? ChatColor.GREEN : ChatColor.RED)) + " " + value;
            sender.sendMessage((Object)((Object)ChatColor.GOLD) + args[1] + " " + option);
        }
        catch (Exception ex) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            ex.printStackTrace();
        }
        return true;
    }

    private boolean intervalSet(CommandSender sender, String[] args) {
        try {
            int setting = NumberUtils.toInt((String)args[2], (int)1);
            MinecraftServer.cauldronConfig.set(args[1], setting);
        }
        catch (Exception ex) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        return true;
    }

    private boolean setToggle(CommandSender sender, String[] args) {
        try {
            Setting toggle = MinecraftServer.cauldronConfig.getSettings().get(args[1]);
            if (toggle == null && MinecraftServer.cauldronConfig.isSet(args[1])) {
                toggle = new BoolSetting(MinecraftServer.cauldronConfig, args[1], MinecraftServer.cauldronConfig.getBoolean(args[1], false), "");
                MinecraftServer.cauldronConfig.getSettings().put(toggle.path, toggle);
                MinecraftServer.cauldronConfig.load();
            }
            if (toggle == null) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Could not find option: " + args[1]);
                return false;
            }
            if (args.length == 2) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + args[0] + " " + args[1] + " [value]");
                return false;
            }
            toggle.setValue(args[2]);
            Object value = toggle.getValue();
            String option = (Object)((Object)(Boolean.TRUE.equals(value) ? ChatColor.GREEN : ChatColor.RED)) + " " + value;
            sender.sendMessage((Object)((Object)ChatColor.GOLD) + args[1] + " " + option);
            MinecraftServer.cauldronConfig.save();
        }
        catch (Exception ex) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            ex.printStackTrace();
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], COMMANDS, new ArrayList(COMMANDS.size()));
        }
        if (args.length == 2 && "get".equalsIgnoreCase(args[0]) || "set".equalsIgnoreCase(args[0])) {
            return StringUtil.copyPartialMatches(args[1], MinecraftServer.cauldronConfig.getSettings().keySet(), new ArrayList(MinecraftServer.cauldronConfig.getSettings().size()));
        }
        if (args.length == 2 && "chunks".equalsIgnoreCase(args[0])) {
            return StringUtil.copyPartialMatches(args[1], CHUNK_COMMANDS, new ArrayList(CHUNK_COMMANDS.size()));
        }
        return ImmutableList.of();
    }
}

