/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron.command;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.configuration.BoolSetting;
import net.minecraftforge.cauldron.configuration.IntSetting;
import net.minecraftforge.cauldron.configuration.Setting;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class TileEntityCommand
extends Command {
    private static final List<String> COMMANDS = ImmutableList.of((Object)"get", (Object)"set", (Object)"save", (Object)"reload");

    public TileEntityCommand() {
        super("cauldron_te");
        this.description = "Toggle certain TileEntity options";
        this.usageMessage = "/cauldron_te [" + StringUtils.join(COMMANDS, (char)'|') + "] <option> [value]";
        this.setPermission("cauldron.command.cauldron_te");
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 1 && "save".equalsIgnoreCase(args[0])) {
            MinecraftServer.tileEntityConfig.save();
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Config file saved");
            return true;
        }
        if (args.length == 1 && "reload".equalsIgnoreCase(args[0])) {
            MinecraftServer.tileEntityConfig.load();
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Config file reloaded");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        if ("get".equalsIgnoreCase(args[0])) {
            return this.getToggle(sender, args);
        }
        if ("set".equalsIgnoreCase(args[0])) {
            return this.setToggle(sender, args);
        }
        sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
        return false;
    }

    private boolean getToggle(CommandSender sender, String[] args) {
        try {
            Setting toggle = MinecraftServer.tileEntityConfig.getSettings().get(args[1]);
            if (toggle == null && MinecraftServer.tileEntityConfig.isSet(args[1])) {
                if (MinecraftServer.tileEntityConfig.isBoolean(args[1])) {
                    toggle = new BoolSetting(MinecraftServer.tileEntityConfig, args[1], MinecraftServer.tileEntityConfig.getBoolean(args[1], false), "");
                } else if (MinecraftServer.tileEntityConfig.isInt(args[1])) {
                    toggle = new IntSetting(MinecraftServer.tileEntityConfig, args[1], MinecraftServer.tileEntityConfig.getInt(args[1], 1), "");
                }
                if (toggle != null) {
                    MinecraftServer.tileEntityConfig.getSettings().put(toggle.path, toggle);
                    MinecraftServer.tileEntityConfig.load();
                }
            }
            if (toggle == null) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Could not find option: " + args[1]);
                return false;
            }
            Object value = toggle.getValue();
            String option = (Object)((Object)(Boolean.TRUE.equals(value) ? ChatColor.GREEN : ChatColor.RED)) + " " + value;
            sender.sendMessage((Object)((Object)ChatColor.GOLD) + args[1] + " " + option);
        }
        catch (Exception ex) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            ex.printStackTrace();
        }
        return true;
    }

    private boolean intervalSet(CommandSender sender, String[] args) {
        try {
            int setting = NumberUtils.toInt((String)args[2], (int)1);
            MinecraftServer.tileEntityConfig.set(args[1], setting);
        }
        catch (Exception ex) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        return true;
    }

    private boolean setToggle(CommandSender sender, String[] args) {
        try {
            Setting toggle = MinecraftServer.tileEntityConfig.getSettings().get(args[1]);
            if (toggle == null && MinecraftServer.tileEntityConfig.isSet(args[1])) {
                toggle = new BoolSetting(MinecraftServer.tileEntityConfig, args[1], MinecraftServer.tileEntityConfig.getBoolean(args[1], false), "");
                MinecraftServer.tileEntityConfig.getSettings().put(toggle.path, toggle);
                MinecraftServer.tileEntityConfig.load();
            }
            if (toggle == null) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Could not find option: " + args[1]);
                return false;
            }
            if (args.length == 2) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + args[0] + " " + args[1] + " [value]");
                return false;
            }
            toggle.setValue(args[2]);
            Object value = toggle.getValue();
            String option = (Object)((Object)(Boolean.TRUE.equals(value) ? ChatColor.GREEN : ChatColor.RED)) + " " + value;
            sender.sendMessage((Object)((Object)ChatColor.GOLD) + args[1] + " " + option);
            MinecraftServer.tileEntityConfig.save();
        }
        catch (Exception ex) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            ex.printStackTrace();
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], COMMANDS, new ArrayList(COMMANDS.size()));
        }
        if (args.length == 2 && "get".equalsIgnoreCase(args[0]) || "set".equalsIgnoreCase(args[0])) {
            return StringUtil.copyPartialMatches(args[1], MinecraftServer.tileEntityConfig.getSettings().keySet(), new ArrayList(MinecraftServer.tileEntityConfig.getSettings().size()));
        }
        return ImmutableList.of();
    }
}

