/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.command.CauldronCommand;
import net.minecraftforge.cauldron.configuration.BoolSetting;
import net.minecraftforge.cauldron.configuration.ConfigBase;
import net.minecraftforge.cauldron.configuration.Setting;
import org.bukkit.configuration.file.YamlConfiguration;

public class CauldronConfig
extends ConfigBase {
    public static CauldronConfig instance;
    public final BoolSetting reloadPlugins = new BoolSetting(this, "plugin-settings.allow-reload", false, "Allow plugins to be reloaded. WARNING - breaks with some mods. We *will not* support this!");
    public final BoolSetting remapPluginFile = new BoolSetting(this, "plugin-settings.default.remap-plugin-file", false, "Remap the plugin file (dev)");
    private final String HEADER = "This is the main configuration file for Cauldron.\n\nIf you need help with the configuration or have any questions related to Cauldron,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #cauldron @ irc.esper.net ( http://webchat.esper.net/?channel=cauldron )\nForums: http://cauldron.minecraftforge.net/\nCrucible note: aw, those links are dead, join our discord instead https://discord.gg/jwstj4d \n";

    public CauldronConfig(String fileName, String commandName) {
        super(fileName, commandName);
        this.init();
        instance = this;
    }

    public void init() {
        for (Field f : this.getClass().getFields()) {
            if (!Modifier.isFinal(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
            try {
                Setting setting = (Setting)f.get(this);
                if (setting == null) continue;
                this.settings.put(setting.path, setting);
            }
            catch (ClassCastException setting) {
            }
            catch (Throwable t) {
                System.out.println("[Thermos] Failed to initialize a CauldronConfig setting.");
                t.printStackTrace();
            }
        }
        this.load();
    }

    @Override
    public void addCommands() {
        this.commands.put(this.commandName, new CauldronCommand());
    }

    @Override
    public void load() {
        try {
            this.config = YamlConfiguration.loadConfiguration(this.configFile);
            String header = "This is the main configuration file for Cauldron.\n\nIf you need help with the configuration or have any questions related to Cauldron,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #cauldron @ irc.esper.net ( http://webchat.esper.net/?channel=cauldron )\nForums: http://cauldron.minecraftforge.net/\nCrucible note: aw, those links are dead, join our discord instead https://discord.gg/jwstj4d \n\n";
            for (Setting toggle : this.settings.values()) {
                if (!toggle.description.equals("")) {
                    header = header + "Setting: " + toggle.path + " Default: " + toggle.def + "   # " + toggle.description + "\n";
                }
                this.config.addDefault(toggle.path, toggle.def);
                ((Setting)this.settings.get(toggle.path)).setValue(this.config.getString(toggle.path));
            }
            this.config.options().header(header);
            this.config.options().copyDefaults(true);
            this.version = this.getInt("config-version", 1);
            this.set("config-version", 1);
            this.saveWorldConfigs();
            this.save();
        }
        catch (Exception ex) {
            MinecraftServer.I().h("Could not load " + this.configFile);
            ex.printStackTrace();
        }
    }
}

