/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron.configuration;

import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.CauldronHooks;
import net.minecraftforge.cauldron.SushchestvoCache;
import net.minecraftforge.cauldron.command.SushchestvoCommand;
import net.minecraftforge.cauldron.configuration.BoolSetting;
import net.minecraftforge.cauldron.configuration.ConfigBase;
import net.minecraftforge.cauldron.configuration.Setting;
import org.bukkit.configuration.file.YamlConfiguration;

public class SushchestvoConfig
extends ConfigBase {
    public final BoolSetting skipEntityTicks = new BoolSetting(this, "settings.skip-entity-ticks", true, "If enabled, allows the default entity tick skip feature when no players are near.");
    public final BoolSetting enableECanUpdateWarning = new BoolSetting(this, "debug.enable-ent-can-update-warning", false, "Set true to detect which entities should not be ticking.");
    public final BoolSetting preventInvalidEntityUpdates = new BoolSetting(this, "settings.prevent-invalid-entity-updates", true, "Used to determine if an entity should tick and if not the TE is added to a ban list. Note: This should help improve performance.");
    private final String HEADER = "This is the main configuration file for Entities aka Sushchestvos (in Russian).\n\nIf you need help with the configuration or have any questions related to Thermos,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #cauldron @ irc.esper.net ( http://webchat.esper.net/?channel=cauldron )\nForums: http://cauldron.minecraftforge.net/\n";

    public SushchestvoConfig(String fileName, String commandName) {
        super(fileName, commandName);
        this.init();
    }

    @Override
    public void addCommands() {
        this.commands.put(this.commandName, new SushchestvoCommand());
    }

    public void init() {
        this.settings.put(this.skipEntityTicks.path, this.skipEntityTicks);
        this.settings.put(this.enableECanUpdateWarning.path, this.enableECanUpdateWarning);
        this.settings.put(this.preventInvalidEntityUpdates.path, this.preventInvalidEntityUpdates);
        this.load();
    }

    @Override
    public void load() {
        try {
            this.config = YamlConfiguration.loadConfiguration(this.configFile);
            String header = "This is the main configuration file for Entities aka Sushchestvos (in Russian).\n\nIf you need help with the configuration or have any questions related to Thermos,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #cauldron @ irc.esper.net ( http://webchat.esper.net/?channel=cauldron )\nForums: http://cauldron.minecraftforge.net/\n\n";
            for (Setting toggle : this.settings.values()) {
                if (!toggle.description.equals("")) {
                    header = header + "Setting: " + toggle.path + " Default: " + toggle.def + "   # " + toggle.description + "\n";
                }
                this.config.addDefault(toggle.path, toggle.def);
                ((Setting)this.settings.get(toggle.path)).setValue(this.config.getString(toggle.path));
            }
            this.config.options().header(header);
            this.config.options().copyDefaults(true);
            this.version = this.getInt("config-version", 1);
            this.set("config-version", 1);
            for (SushchestvoCache seCache : CauldronHooks.sushchestvoCache.values()) {
                seCache.tickNoPlayers = this.config.getBoolean("world-settings." + seCache.worldName + "." + seCache.configPath + ".tick-no-players", this.config.getBoolean("world-settings.default." + seCache.configPath + ".tick-no-players"));
                seCache.neverEverTick = this.config.getBoolean("world-settings." + seCache.worldName + "." + seCache.configPath + ".never-ever-tick", this.config.getBoolean("world-settings.default." + seCache.configPath + ".never-ever-tick"));
                seCache.tickInterval = this.config.getInt("world-settings." + seCache.worldName + "." + seCache.configPath + ".tick-interval", this.config.getInt("world-settings.default." + seCache.configPath + ".tick-interval"));
            }
            this.saveWorldConfigs();
            this.save();
        }
        catch (Exception ex) {
            MinecraftServer.I().h("Could not load " + this.configFile);
            ex.printStackTrace();
        }
    }
}

