/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class OreDictionary {
    private static boolean hasInit = false;
    private static List<String> idToName = new ArrayList<String>();
    private static Map<String, Integer> nameToId = new HashMap<String, Integer>(128);
    private static List<ArrayList<add>> idToStack = Lists.newArrayList();
    private static List<ArrayList<add>> idToStackUn = Lists.newArrayList();
    private static Map<Integer, List<Integer>> stackToId = Maps.newHashMapWithExpectedSize((int)96);
    public static final ArrayList<add> EMPTY_LIST = new UnmodifiableArrayList<add>(Lists.newArrayList());
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new add(ajn.r, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("logWood", new add(ajn.s, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new add(ajn.f, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new add((aji)ajn.bx, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", ajn.ad);
            OreDictionary.registerOre("stairWood", ajn.bF);
            OreDictionary.registerOre("stairWood", ajn.bG);
            OreDictionary.registerOre("stairWood", ajn.bH);
            OreDictionary.registerOre("stairWood", ajn.ck);
            OreDictionary.registerOre("stairWood", ajn.cl);
            OreDictionary.registerOre("stickWood", ade.y);
            OreDictionary.registerOre("treeSapling", new add(ajn.g, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new add((aji)ajn.t, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new add((aji)ajn.u, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("oreGold", ajn.o);
            OreDictionary.registerOre("oreIron", ajn.p);
            OreDictionary.registerOre("oreLapis", ajn.x);
            OreDictionary.registerOre("oreDiamond", ajn.ag);
            OreDictionary.registerOre("oreRedstone", ajn.ax);
            OreDictionary.registerOre("oreEmerald", ajn.bA);
            OreDictionary.registerOre("oreQuartz", ajn.bY);
            OreDictionary.registerOre("oreCoal", ajn.q);
            OreDictionary.registerOre("blockGold", ajn.R);
            OreDictionary.registerOre("blockIron", ajn.S);
            OreDictionary.registerOre("blockLapis", ajn.y);
            OreDictionary.registerOre("blockDiamond", ajn.ah);
            OreDictionary.registerOre("blockRedstone", ajn.bX);
            OreDictionary.registerOre("blockEmerald", ajn.bE);
            OreDictionary.registerOre("blockQuartz", ajn.ca);
            OreDictionary.registerOre("blockCoal", ajn.ci);
            OreDictionary.registerOre("blockGlassColorless", ajn.w);
            OreDictionary.registerOre("blockGlass", ajn.w);
            OreDictionary.registerOre("blockGlass", new add((aji)ajn.cn, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paneGlassColorless", ajn.aZ);
            OreDictionary.registerOre("paneGlass", ajn.aZ);
            OreDictionary.registerOre("paneGlass", new add((aji)ajn.co, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("ingotIron", ade.j);
            OreDictionary.registerOre("ingotGold", ade.k);
            OreDictionary.registerOre("ingotBrick", ade.aC);
            OreDictionary.registerOre("ingotBrickNether", ade.bT);
            OreDictionary.registerOre("nuggetGold", ade.bl);
            OreDictionary.registerOre("gemDiamond", ade.i);
            OreDictionary.registerOre("gemEmerald", ade.bC);
            OreDictionary.registerOre("gemQuartz", ade.bU);
            OreDictionary.registerOre("dustRedstone", ade.ax);
            OreDictionary.registerOre("dustGlowstone", ade.aO);
            OreDictionary.registerOre("gemLapis", new add(ade.aR, 1, 4));
            OreDictionary.registerOre("slimeball", ade.aH);
            OreDictionary.registerOre("glowstone", ajn.aN);
            OreDictionary.registerOre("cropWheat", ade.O);
            OreDictionary.registerOre("cropPotato", ade.bG);
            OreDictionary.registerOre("cropCarrot", ade.bF);
            OreDictionary.registerOre("stone", ajn.b);
            OreDictionary.registerOre("cobblestone", ajn.e);
            OreDictionary.registerOre("sandstone", new add(ajn.A, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sand", new add((aji)ajn.m, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("dye", new add(ade.aR, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("record", ade.cd);
            OreDictionary.registerOre("record", ade.ce);
            OreDictionary.registerOre("record", ade.cf);
            OreDictionary.registerOre("record", ade.cg);
            OreDictionary.registerOre("record", ade.ch);
            OreDictionary.registerOre("record", ade.ci);
            OreDictionary.registerOre("record", ade.cj);
            OreDictionary.registerOre("record", ade.ck);
            OreDictionary.registerOre("record", ade.cl);
            OreDictionary.registerOre("record", ade.cm);
            OreDictionary.registerOre("record", ade.cn);
            OreDictionary.registerOre("record", ade.co);
        }
        HashMap<add, String> replacements = new HashMap<add, String>();
        replacements.put(new add(ade.y), "stickWood");
        replacements.put(new add(ajn.f), "plankWood");
        replacements.put(new add(ajn.f, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new add(ajn.b), "stone");
        replacements.put(new add(ajn.b, 1, Short.MAX_VALUE), "stone");
        replacements.put(new add(ajn.e), "cobblestone");
        replacements.put(new add(ajn.e, 1, Short.MAX_VALUE), "cobblestone");
        replacements.put(new add(ade.k), "ingotGold");
        replacements.put(new add(ade.j), "ingotIron");
        replacements.put(new add(ade.i), "gemDiamond");
        replacements.put(new add(ade.bC), "gemEmerald");
        replacements.put(new add(ade.ax), "dustRedstone");
        replacements.put(new add(ade.aO), "dustGlowstone");
        replacements.put(new add(ajn.aN), "glowstone");
        replacements.put(new add(ade.aH), "slimeball");
        replacements.put(new add(ajn.w), "blockGlassColorless");
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i = 0; i < 16; ++i) {
            add dye = new add(ade.aR, 1, i);
            add block = new add((aji)ajn.cn, 1, 15 - i);
            add pane = new add((aji)ajn.co, 1, 15 - i);
            if (!hasInit) {
                OreDictionary.registerOre("dye" + dyes[i], dye);
                OreDictionary.registerOre("blockGlass" + dyes[i], block);
                OreDictionary.registerOre("paneGlass" + dyes[i], pane);
            }
            replacements.put(dye, "dye" + dyes[i]);
            replacements.put(block, "blockGlass" + dyes[i]);
            replacements.put(pane, "paneGlass" + dyes[i]);
        }
        hasInit = true;
        add[] replaceStacks = replacements.keySet().toArray(new add[replacements.keySet().size()]);
        add[] exclusions = new add[]{new add(ajn.y), new add(ade.aX), new add(ajn.aV), new add((aji)ajn.U, 1, Short.MAX_VALUE), new add(ajn.ar), new add(ajn.bK), new add(ajn.ad), new add(ajn.bF), new add(ajn.bG), new add(ajn.bH), new add(ajn.ck), new add(ajn.cl), new add(ajn.aZ)};
        List recipes = afe.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            add output;
            afh recipe;
            if (obj instanceof afh) {
                recipe = (afh)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || output == null || !OreDictionary.containsMatch(true, recipe.c, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (!(obj instanceof afi) || (output = (recipe = (afi)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || output == null || !OreDictionary.containsMatch(true, recipe.b.toArray(new add[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((afg)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((afi)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            FMLLog.info("Replaced %d ore recipies", recipesToRemove.size());
        }
    }

    public static int getOreID(String name) {
        Integer val = nameToId.get(name);
        if (val == null) {
            idToName.add(name);
            val = idToName.size() - 1;
            nameToId.put(name, val);
            idToStack.add(new ArrayList());
            idToStackUn.add(new UnmodifiableArrayList<add>(idToStack.get(val)));
        }
        return val;
    }

    public static String getOreName(int id) {
        return id >= 0 && id < idToName.size() ? idToName.get(id) : "Unknown";
    }

    @Deprecated
    public static int getOreID(add stack) {
        if (stack == null || stack.b() == null) {
            return -1;
        }
        String registryName = stack.b().delegate.name();
        if (registryName == null) {
            FMLLog.log(Level.DEBUG, "Attempted to find the oreIDs for an unregistered object (%s). This won't work very well.", stack);
            return -1;
        }
        int id = GameData.getItemRegistry().getId(registryName);
        List<Integer> ids = stackToId.get(id);
        if (ids == null || ids.size() == 0) {
            ids = stackToId.get(id | stack.k() + 1 << 16);
        }
        return ids != null && ids.size() > 0 ? ids.get(0) : -1;
    }

    public static int[] getOreIDs(add stack) {
        if (stack == null || stack.b() == null) {
            return new int[0];
        }
        HashSet<Integer> set = new HashSet<Integer>();
        String registryName = stack.b().delegate.name();
        if (registryName == null) {
            FMLLog.log(Level.DEBUG, "Attempted to find the oreIDs for an unregistered object (%s). This won't work very well.", stack);
            return new int[0];
        }
        int id = GameData.getItemRegistry().getId(registryName);
        List<Integer> ids = stackToId.get(id);
        if (ids != null) {
            set.addAll(ids);
        }
        if ((ids = stackToId.get(id | stack.k() + 1 << 16)) != null) {
            set.addAll(ids);
        }
        Integer[] tmp = set.toArray(new Integer[set.size()]);
        int[] ret = new int[tmp.length];
        for (int x = 0; x < tmp.length; ++x) {
            ret[x] = tmp[x];
        }
        return ret;
    }

    public static ArrayList<add> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static List<add> getOres(String name, boolean alwaysCreateEntry) {
        if (alwaysCreateEntry) {
            return OreDictionary.getOres(OreDictionary.getOreID(name));
        }
        return nameToId.get(name) != null ? OreDictionary.getOres(OreDictionary.getOreID(name)) : EMPTY_LIST;
    }

    public static boolean doesOreNameExist(String name) {
        return nameToId.get(name) != null;
    }

    public static String[] getOreNames() {
        return idToName.toArray(new String[idToName.size()]);
    }

    @Deprecated
    public static ArrayList<add> getOres(Integer id) {
        return OreDictionary.getOres((int)id);
    }

    private static ArrayList<add> getOres(int id) {
        while (idToName.size() < id + 1) {
            String name = "Filler: " + idToName.size();
            idToName.add(name);
            nameToId.put(name, idToName.size() - 1);
            idToStack.add(null);
            idToStackUn.add(EMPTY_LIST);
        }
        return idToStackUn.size() > id ? idToStackUn.get(id) : EMPTY_LIST;
    }

    private static boolean containsMatch(boolean strict, add[] inputs, add ... targets) {
        for (add input : inputs) {
            for (add target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsMatch(boolean strict, List<add> inputs, add ... targets) {
        for (add input : inputs) {
            for (add target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(add target, add input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.b() == input.b() && (target.k() == Short.MAX_VALUE && !strict || target.k() == input.k());
    }

    public static void registerOre(String name, adb ore) {
        OreDictionary.registerOre(name, new add(ore));
    }

    public static void registerOre(String name, aji ore) {
        OreDictionary.registerOre(name, new add(ore));
    }

    public static void registerOre(String name, add ore) {
        OreDictionary.registerOreImpl(name, ore);
    }

    @Deprecated
    public static void registerOre(int id, adb ore) {
        OreDictionary.registerOre(id, new add(ore));
    }

    @Deprecated
    public static void registerOre(int id, aji ore) {
        OreDictionary.registerOre(id, new add(ore));
    }

    @Deprecated
    public static void registerOre(int id, add ore) {
        OreDictionary.registerOreImpl(OreDictionary.getOreName(id), ore);
    }

    private static void registerOreImpl(String name, add ore) {
        ArrayList ids;
        int hash;
        if (name == null || name.isEmpty() || "Unknown".equals(name)) {
            return;
        }
        if (ore == null || ore.b() == null) {
            FMLLog.bigWarning("Invalid registration attempt for an Ore Dictionary item with name %s has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", name);
            return;
        }
        int oreID = OreDictionary.getOreID(name);
        String registryName = ore.b().delegate.name();
        if (registryName == null) {
            FMLLog.bigWarning("A broken ore dictionary registration with name %s has occurred. It adds an item (type: %s) which is currently unknown to the game registry. This dictionary item can only support a single value when registered with ores like this, and NO I am not going to turn this spam off. Just register your ore dictionary entries after the GameRegistry.\nTO USERS: YES this is a BUG in the mod " + Loader.instance().activeModContainer().getName() + " report it to them!", name, ore.b().getClass());
            hash = -1;
        } else {
            hash = GameData.getItemRegistry().getId(registryName);
        }
        if (ore.k() != Short.MAX_VALUE) {
            hash |= ore.k() + 1 << 16;
        }
        if ((ids = stackToId.get(hash)) != null && ids.contains(oreID)) {
            return;
        }
        if (ids == null) {
            ids = Lists.newArrayList();
            stackToId.put(hash, ids);
        }
        ids.add(oreID);
        ore = ore.m();
        idToStack.get(oreID).add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static void rebakeMap() {
        stackToId.clear();
        for (int id = 0; id < idToStack.size(); ++id) {
            List ores = idToStack.get(id);
            if (ores == null) continue;
            for (add ore : ores) {
                ArrayList ids;
                int hash;
                String name = ore.b().delegate.name();
                if (name == null) {
                    FMLLog.log(Level.DEBUG, "Defaulting unregistered ore dictionary entry for ore dictionary %s: type %s to -1", OreDictionary.getOreName(id), ore.b().getClass());
                    hash = -1;
                } else {
                    hash = GameData.getItemRegistry().getId(name);
                }
                if (ore.k() != Short.MAX_VALUE) {
                    hash |= ore.k() + 1 << 16;
                }
                if ((ids = stackToId.get(hash)) == null) {
                    ids = Lists.newArrayList();
                    stackToId.put(hash, ids);
                }
                ids.add(id);
            }
        }
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    private static class UnmodifiableArrayList<E>
    extends ArrayList<E> {
        final ArrayList<? extends E> list;

        UnmodifiableArrayList(ArrayList<? extends E> list) {
            super(0);
            this.list = list;
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public String toString() {
            return this.list.toString();
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.list.containsAll(coll);
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                private final ListIterator<? extends E> i;
                {
                    this.i = list.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return Collections.unmodifiableList(this.list.subList(fromIndex, toIndex));
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> i;
                {
                    this.i = list.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final add Ore;

        public OreRegisterEvent(String name, add ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

