/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public class VersionCommand
extends BukkitCommand {
    public VersionCommand(String name) {
        super(name);
        this.description = "Gets the version of this server including any plugins in use";
        this.usageMessage = "/version [plugin name]";
        this.setPermission("bukkit.command.version");
        this.setAliases(Arrays.asList("ver", "about"));
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(String.format("This server is running Crucible | https://github.com/CrucibleMC/Crucible | %s | %s", Bukkit.getBukkitVersion(), Bukkit.getVersion()));
        } else {
            sender.sendMessage("This server is not running any plugins.");
        }
        return true;
    }

    private void describeToSender(Plugin plugin, CommandSender sender) {
        sender.sendMessage("Author: Fracica");
    }

    private String getAuthors(PluginDescriptionFile desc) {
        return "Fracica";
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        ArrayList<String> completions = new ArrayList<String>();
        completions.add("None");
        return completions;
    }
}

