/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.entity;

import org.apache.commons.lang.Validate;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;

public class CraftItemFrame
extends CraftHanging
implements ItemFrame {
    public CraftItemFrame(CraftServer server, st entity) {
        super(server, (ss)entity);
    }

    static int toInteger(Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE: {
                return 1;
            }
            case FLIPPED: {
                return 2;
            }
            case COUNTER_CLOCKWISE: {
                return 3;
            }
        }
        throw new IllegalArgumentException((Object)((Object)rotation) + " is not applicable to an ItemFrame");
    }

    @Override
    public boolean setFacingDirection(BlockFace face, boolean force) {
        if (!super.setFacingDirection(face, force)) {
            return false;
        }
        mt world = ((CraftWorld)this.getWorld()).getHandle();
        world.r().b((sa)this.getHandle());
        world.r().a((sa)this.getHandle());
        return true;
    }

    @Override
    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().j());
    }

    @Override
    public void setItem(ItemStack item) {
        if (item == null || item.getTypeId() == 0) {
            this.getHandle().z().a(2, 5);
            this.getHandle().z().h(2);
        } else {
            this.getHandle().a(CraftItemStack.asNMSCopy(item));
        }
    }

    @Override
    public Rotation getRotation() {
        return this.toBukkitRotation(this.getHandle().k());
    }

    @Override
    public void setRotation(Rotation rotation) {
        Validate.notNull((Object)((Object)rotation), (String)"Rotation cannot be null");
        this.getHandle().c(CraftItemFrame.toInteger(rotation));
    }

    Rotation toBukkitRotation(int value) {
        switch (value) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE;
            }
            case 2: {
                return Rotation.FLIPPED;
            }
            case 3: {
                return Rotation.COUNTER_CLOCKWISE;
            }
        }
        throw new AssertionError((Object)("Unknown rotation " + value + " for " + this.getHandle()));
    }

    public st getHandle() {
        return (st)this.entity;
    }

    @Override
    public String toString() {
        return "CraftItemFrame{item=" + this.getItem() + ", rotation=" + (Object)((Object)this.getRotation()) + "}";
    }

    @Override
    public EntityType getType() {
        return EntityType.ITEM_FRAME;
    }
}

