/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.entity;

import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftEntityEquipment;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Fish;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class CraftLivingEntity
extends CraftEntity
implements LivingEntity {
    public Class<? extends sv> entityClass;
    public String entityName;
    private CraftEntityEquipment equipment;

    public CraftLivingEntity(CraftServer server, sv entity) {
        super(server, (sa)entity);
        this.entityClass = entity.getClass();
        this.entityName = EntityRegistry.getCustomEntityTypeName(this.entityClass);
        if (this.entityName == null) {
            this.entityName = entity.b_();
        }
        if (entity instanceof sw) {
            this.equipment = new CraftEntityEquipment(this);
        }
    }

    @Override
    public double getHealth() {
        return Math.min((double)Math.max(0.0f, this.getHandle().aS()), this.getMaxHealth());
    }

    @Override
    public void setHealth(double health) {
        if (health < 0.0 || health > this.getMaxHealth()) {
            throw new IllegalArgumentException("Health must be between 0 and " + this.getMaxHealth());
        }
        this.getHandle().g((float)health);
        if (this.entity instanceof mw && health == 0.0) {
            ((mw)this.entity).a(ro.j);
        }
    }

    @Override
    public double getMaxHealth() {
        return this.getHandle().aY();
    }

    @Override
    public void setMaxHealth(double amount) {
        Validate.isTrue((amount > 0.0 ? 1 : 0) != 0, (String)"Max health must be greater than 0");
        this.getHandle().a(yj.a).a(amount);
        if (this.getHealth() > amount) {
            this.setHealth(amount);
        }
    }

    @Override
    public void resetMaxHealth() {
        this.setMaxHealth(this.getHandle().aY());
    }

    @Override
    @Deprecated
    public Egg throwEgg() {
        return this.launchProjectile(Egg.class);
    }

    @Override
    @Deprecated
    public Snowball throwSnowball() {
        return this.launchProjectile(Snowball.class);
    }

    @Override
    public double getEyeHeight() {
        return this.getHandle().g();
    }

    @Override
    public double getEyeHeight(boolean ignoreSneaking) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(HashSet<Byte> transparent, int maxDistance, int maxLength) {
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator(this, maxDistance);
        while (itr.hasNext()) {
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            int id = block.getTypeId();
            if (!(transparent == null ? id != 0 : !transparent.contains((byte)id))) continue;
            break;
        }
        return blocks;
    }

    @Override
    public List<Block> getLineOfSight(HashSet<Byte> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    @Override
    public Block getTargetBlock(HashSet<Byte> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    @Override
    public List<Block> getLastTwoTargetBlocks(HashSet<Byte> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    @Override
    @Deprecated
    public Arrow shootArrow() {
        return this.launchProjectile(Arrow.class);
    }

    @Override
    public int getRemainingAir() {
        return this.getHandle().ar();
    }

    @Override
    public void setRemainingAir(int ticks) {
        this.getHandle().h(ticks);
    }

    @Override
    public int getMaximumAir() {
        return this.getHandle().maxAirTicks;
    }

    @Override
    public void setMaximumAir(int ticks) {
        this.getHandle().maxAirTicks = ticks;
    }

    @Override
    public void damage(double amount) {
        this.damage(amount, null);
    }

    @Override
    public void damage(double amount, Entity source) {
        ro reason = ro.j;
        if (source instanceof HumanEntity) {
            reason = ro.a((yz)((CraftHumanEntity)source).getHandle());
        } else if (source instanceof LivingEntity) {
            reason = ro.a((sv)((CraftLivingEntity)source).getHandle());
        }
        if (this.entity instanceof xa) {
            ((xa)this.entity).e(reason, (float)amount);
        } else {
            this.entity.a(reason, (float)amount);
        }
    }

    @Override
    public Location getEyeLocation() {
        Location loc = this.getLocation();
        loc.setY(loc.getY() + this.getEyeHeight());
        return loc;
    }

    @Override
    public int getMaximumNoDamageTicks() {
        return this.getHandle().aH;
    }

    @Override
    public void setMaximumNoDamageTicks(int ticks) {
        this.getHandle().aH = ticks;
    }

    @Override
    public double getLastDamage() {
        return this.getHandle().bb;
    }

    @Override
    public void setLastDamage(double damage) {
        this.getHandle().bb = (float)damage;
    }

    @Override
    public int getNoDamageTicks() {
        return this.getHandle().ad;
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        this.getHandle().ad = ticks;
    }

    public sv getHandle() {
        return (sv)this.entity;
    }

    public void setHandle(sv entity) {
        super.setHandle((sa)entity);
    }

    @Override
    public String toString() {
        return this.entityName;
    }

    @Override
    public Player getKiller() {
        return this.getHandle().aR == null ? null : (Player)((Object)this.getHandle().aR.getBukkitEntity());
    }

    @Override
    public boolean addPotionEffect(PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    @Override
    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        if (this.hasPotionEffect(effect.getType())) {
            if (!force) {
                return false;
            }
            this.removePotionEffect(effect.getType());
        }
        this.getHandle().c(new rw(effect.getType().getId(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient()));
        return true;
    }

    @Override
    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean success = true;
        for (PotionEffect effect : effects) {
            success &= this.addPotionEffect(effect);
        }
        return success;
    }

    @Override
    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getHandle().a(rv.a[type.getId()]);
    }

    @Override
    public PotionEffect getPotionEffect(PotionEffectType type) {
        rw handle = this.getHandle().b(rv.a[type.getId()]);
        return handle == null ? null : new PotionEffect(PotionEffectType.getById(handle.a()), handle.b(), handle.c(), handle.e());
    }

    @Override
    public void removePotionEffect(PotionEffectType type) {
        this.getHandle().m(type.getId());
    }

    @Override
    public Collection<PotionEffect> getActivePotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (Object raw : this.getHandle().f.values()) {
            rw handle;
            if (!(raw instanceof rw) || PotionEffectType.getById((handle = (rw)raw).a()) == null) continue;
            effects.add(new PotionEffect(PotionEffectType.getById(handle.a()), handle.b(), handle.c(), handle.e()));
        }
        return effects;
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        mt world = ((CraftWorld)this.getWorld()).getHandle();
        Object launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new zj((ahb)world, this.getHandle());
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new zl((ahb)world, this.getHandle());
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new zm((ahb)world, this.getHandle());
        } else if (Arrow.class.isAssignableFrom(projectile)) {
            launch = new zc((ahb)world, this.getHandle(), 1.0f);
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            launch = new zo((ahb)world, this.getHandle(), CraftItemStack.asNMSCopy(new ItemStack(Material.POTION, 1)));
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new zn((ahb)world, this.getHandle());
        } else if (Fish.class.isAssignableFrom(projectile) && this.getHandle() instanceof yz) {
            launch = new xe((ahb)world, (yz)this.getHandle());
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection().multiply(10);
            launch = SmallFireball.class.isAssignableFrom(projectile) ? new zi((ahb)world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : (WitherSkull.class.isAssignableFrom(projectile) ? new zp((ahb)world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : new zg((ahb)world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()));
            launch.projectileSource = this;
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
        Validate.notNull((Object)launch, (String)"Projectile not supported");
        if (velocity != null) {
            ((Projectile)((Object)launch.getBukkitEntity())).setVelocity(velocity);
        }
        world.d((sa)launch);
        return (T)((Projectile)((Object)launch.getBukkitEntity()));
    }

    @Override
    public EntityType getType() {
        EntityType type = EntityType.fromName(this.entityName);
        if (type != null) {
            return type;
        }
        return EntityType.UNKNOWN;
    }

    @Override
    public boolean hasLineOfSight(Entity other) {
        return this.getHandle().p(((CraftEntity)other).getHandle());
    }

    @Override
    public boolean getRemoveWhenFarAway() {
        return this.getHandle() instanceof sw && !((sw)this.getHandle()).bt;
    }

    @Override
    public void setRemoveWhenFarAway(boolean remove) {
        if (this.getHandle() instanceof sw) {
            ((sw)this.getHandle()).bt = !remove;
        }
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    @Override
    public boolean getCanPickupItems() {
        return this.getHandle() instanceof sw && ((sw)this.getHandle()).bs;
    }

    @Override
    public void setCanPickupItems(boolean pickup) {
        if (this.getHandle() instanceof sw) {
            ((sw)this.getHandle()).bs = pickup;
        }
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.getHealth() == 0.0) {
            return false;
        }
        return super.teleport(location, cause);
    }

    @Override
    public String getCustomName() {
        if (!(this.getHandle() instanceof sw)) {
            return null;
        }
        String name = ((sw)this.getHandle()).bG();
        if (name == null || name.length() == 0) {
            return null;
        }
        return name;
    }

    @Override
    public void setCustomName(String name) {
        if (!(this.getHandle() instanceof sw)) {
            return;
        }
        if (name == null) {
            name = "";
        }
        if (name.length() > 64) {
            name = name.substring(0, 64);
        }
        ((sw)this.getHandle()).a(name);
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.getHandle() instanceof sw && ((sw)this.getHandle()).bI();
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        if (this.getHandle() instanceof sw) {
            ((sw)this.getHandle()).g(flag);
        }
    }

    @Override
    public boolean isLeashed() {
        if (!(this.getHandle() instanceof sw)) {
            return false;
        }
        return ((sw)this.getHandle()).bO() != null;
    }

    @Override
    public Entity getLeashHolder() throws IllegalStateException {
        if (!this.isLeashed()) {
            throw new IllegalStateException("Entity not leashed");
        }
        return ((sw)this.getHandle()).bO().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        ((sw)this.getHandle()).a(true, false);
        return true;
    }

    @Override
    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle() instanceof xc || !(this.getHandle() instanceof sw)) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        ((sw)this.getHandle()).b(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    @Override
    @Deprecated
    public int _INVALID_getLastDamage() {
        return NumberConversions.ceil(this.getLastDamage());
    }

    @Override
    @Deprecated
    public void _INVALID_setLastDamage(int damage) {
        this.setLastDamage(damage);
    }

    @Override
    @Deprecated
    public void _INVALID_damage(int amount) {
        this.damage(amount);
    }

    @Override
    @Deprecated
    public void _INVALID_damage(int amount, Entity source) {
        this.damage(amount, source);
    }

    @Override
    @Deprecated
    public int _INVALID_getHealth() {
        return NumberConversions.ceil(this.getHealth());
    }

    @Override
    @Deprecated
    public void _INVALID_setHealth(int health) {
        this.setHealth(health);
    }

    @Override
    @Deprecated
    public int _INVALID_getMaxHealth() {
        return NumberConversions.ceil(this.getMaxHealth());
    }

    @Override
    @Deprecated
    public void _INVALID_setMaxHealth(int health) {
        this.setMaxHealth(health);
    }
}

