/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.entity;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.Validate;
import org.bukkit.Achievement;
import org.bukkit.BanList;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.v1_7_R4.CraftEffect;
import org.bukkit.craftbukkit.v1_7_R4.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_7_R4.CraftParticle;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftSound;
import org.bukkit.craftbukkit.v1_7_R4.CraftStatistic;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.MinecraftParticles;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftSign;
import org.bukkit.craftbukkit.v1_7_R4.conversations.ConversationTracker;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_7_R4.map.CraftMapView;
import org.bukkit.craftbukkit.v1_7_R4.map.RenderData;
import org.bukkit.craftbukkit.v1_7_R4.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_7_R4.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_7_R4.util.CraftMagicNumbers;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.scoreboard.Scoreboard;
import thermos.thermite.ThermiteTeleportationHandler;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player {
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Set<UUID> hiddenPlayers = new HashSet<UUID>();
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private boolean hasPlayedBefore = false;
    private int hash = 0;
    private double health = 20.0;
    private final Player.Spigot spigot = new Player.Spigot(){

        @Override
        public InetSocketAddress getRawAddress() {
            return (InetSocketAddress)CraftPlayer.this.getHandle().a.a.getRawAddress();
        }

        @Override
        public boolean getCollidesWithEntities() {
            return CraftPlayer.this.getHandle().collidesWithEntities;
        }

        @Override
        public void setCollidesWithEntities(boolean collides) {
            CraftPlayer.this.getHandle().collidesWithEntities = collides;
            CraftPlayer.this.getHandle().k = collides;
        }

        @Override
        public void respawn() {
            if (CraftPlayer.this.getHealth() <= 0.0 && CraftPlayer.this.isOnline()) {
                CraftPlayer.this.server.getServer().ah().respawnPlayer(CraftPlayer.this.getHandle(), 0);
            }
        }

        @Override
        public String getLocale() {
            return CraftPlayer.this.getHandle().bM;
        }

        @Override
        public void sendMessage(BaseComponent component) {
            this.sendMessage(new BaseComponent[]{component});
        }

        @Override
        public void sendMessage(BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().a == null) {
                return;
            }
            gj packet = new gj();
            packet.components = components;
            CraftPlayer.this.getHandle().a.a((ft)packet);
        }

        @Override
        public int getPing() {
            return CraftPlayer.this.getHandle().h;
        }

        @Override
        public void sendMessage(ChatMessageType position, BaseComponent component) {
            if (position == ChatMessageType.CHAT) {
                this.sendMessage(component);
                return;
            }
            throw new UnsupportedOperationException("This method requires Crucible NecroTempus to work, you can get it at https://github.com/CrucibleMC/NecroTempus.");
        }

        @Override
        public void sendMessage(ChatMessageType position, BaseComponent ... components) {
            if (position == ChatMessageType.CHAT) {
                this.sendMessage(components);
                return;
            }
            throw new UnsupportedOperationException("This method requires Crucible NecroTempus to work, you can get it at https://github.com/CrucibleMC/NecroTempus.");
        }
    };
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    public String playerListHeaderString;
    public String playerListFooterString;

    public CraftPlayer(CraftServer server, mw entity) {
        super(server, (yz)entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    public GameProfile getProfile() {
        return this.getHandle().bJ();
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().g(this.getProfile());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().a(this.getProfile());
        } else {
            this.server.getHandle().b(this.getProfile());
        }
        this.perm.recalculatePermissions();
    }

    @Override
    public boolean isOnline() {
        if (this.getHandle() instanceof FakePlayer) {
            return true;
        }
        for (Object obj : this.server.getHandle().e) {
            mw player = (mw)obj;
            if (player == null || this.getHandle() != player && player.getBukkitEntity() != this && !this.getHandle().bJ().getId().equals(player.bJ().getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public InetSocketAddress getAddress() {
        if (this.getHandle().a == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().a.a.b();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    @Override
    public double getEyeHeight() {
        return this.getEyeHeight(false);
    }

    @Override
    public double getEyeHeight(boolean ignoreSneaking) {
        if (ignoreSneaking) {
            return 1.62;
        }
        if (this.isSneaking()) {
            return 1.54;
        }
        return 1.62;
    }

    @Override
    public void sendRawMessage(String message) {
        if (this.getHandle().a == null) {
            return;
        }
        for (fj component : CraftChatMessage.fromString(message)) {
            this.getHandle().a.a((ft)new gj(component));
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String[] messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public String getDisplayName() {
        return this.getHandle().displayName;
    }

    @Override
    public void setDisplayName(String name) {
        this.getHandle().displayName = name == null ? this.getName() : name;
    }

    @Override
    public String getPlayerListName() {
        return this.getHandle().listName;
    }

    @Override
    public void setPlayerListName(String name) {
        String oldName = this.getHandle().listName;
        if (name == null) {
            name = this.getName();
        }
        if (oldName.equals(name)) {
            return;
        }
        if (name.length() > 16) {
            throw new IllegalArgumentException("Player list names can only be a maximum of 16 characters long");
        }
        for (int i = 0; i < this.server.getHandle().e.size(); ++i) {
            if (!((mw)this.server.getHandle().e.get((int)i)).listName.equals(name)) continue;
            throw new IllegalArgumentException(name + " is already assigned as a player list name for someone");
        }
        this.getHandle().listName = name;
        ho oldpacket = new ho(oldName, false, 9999);
        ho packet = new ho(name, true, this.getHandle().h);
        for (int i = 0; i < this.server.getHandle().e.size(); ++i) {
            mw entityplayer = (mw)this.server.getHandle().e.get(i);
            if (entityplayer.a == null || !entityplayer.getBukkitEntity().canSee(this)) continue;
            entityplayer.a.a((ft)oldpacket);
            entityplayer.a.a((ft)packet);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getName() == null || other.getName() == null) {
            return false;
        }
        boolean nameEquals = this.getName().equalsIgnoreCase(other.getName());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return nameEquals && idEquals;
    }

    @Override
    public void kickPlayer(String message) {
        if (Thread.currentThread() != MinecraftServer.I().primaryThread) {
            throw new IllegalStateException("Asynchronous player kick!");
        }
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.c(message == null ? "" : message);
    }

    @Override
    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    @Override
    public void setCompassTarget(Location loc) {
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.a((ft)new ig(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
    }

    @Override
    public void chat(String msg) {
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.chat(msg, false);
    }

    @Override
    public boolean performCommand(String command) {
        return this.server.dispatchCommand(this, command);
    }

    @Override
    public void playNote(Location loc, byte instrument, byte note) {
        if (this.getHandle().a == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "bd";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bassattack";
            }
        }
        this.getHandle().a.a((ft)new hc("note." + instrumentName, (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ(), 3.0f, (float)note));
    }

    @Override
    public void playNote(Location loc, Instrument instrument, Note note) {
        if (this.getHandle().a == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument.ordinal()) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "bd";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bassattack";
            }
        }
        this.getHandle().a.a((ft)new hc("note." + instrumentName, (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ(), 3.0f, (float)note.getId()));
    }

    @Override
    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        if (sound == null) {
            return;
        }
        this.playSound(loc, CraftSound.getSound(sound), volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, float volume, float pitch) {
        if (loc == null || sound == null || this.getHandle().a == null) {
            return;
        }
        double x = (double)loc.getBlockX() + 0.5;
        double y2 = (double)loc.getBlockY() + 0.5;
        double z2 = (double)loc.getBlockZ() + 0.5;
        hc packet = new hc(sound, x, y2, z2, volume, pitch);
        this.getHandle().a.a((ft)packet);
    }

    @Override
    public void playEffect(Location loc, Effect effect, int data) {
        if (this.getHandle().a == null) {
            return;
        }
        int packetData = effect.getId();
        ha packet = new ha(packetData, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), data, false);
        this.getHandle().a.a((ft)packet);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data) {
        if (data != null) {
            Validate.isTrue((boolean)data.getClass().equals(effect.getData()), (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        int datavalue = data == null ? 0 : CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    @Override
    public void sendBlockChange(Location loc, Material material, byte data) {
        this.sendBlockChange(loc, material.getId(), data);
    }

    @Override
    public void sendBlockChange(Location loc, int material, byte data) {
        if (this.getHandle().a == null) {
            return;
        }
        gh packet = new gh(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), (ahb)((CraftWorld)loc.getWorld()).getHandle());
        packet.d = CraftMagicNumbers.getBlock(material);
        packet.e = data;
        this.getHandle().a.a((ft)packet);
    }

    @Override
    public void sendSignChange(Location loc, String[] lines) {
        if (this.getHandle().a == null) {
            return;
        }
        if (lines == null) {
            lines = new String[4];
        }
        Validate.notNull((Object)loc, (String)"Location can not be null");
        if (lines.length < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
        String[] astring = CraftSign.sanitizeLines(lines);
        this.getHandle().a.a((ft)new ii(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), astring));
    }

    @Override
    public boolean sendChunkChange(Location loc, int sx2, int sy2, int sz2, byte[] data) {
        if (this.getHandle().a == null) {
            return false;
        }
        throw new NotImplementedException("Chunk changes do not yet work");
    }

    @Override
    public void sendMap(MapView map) {
        if (this.getHandle().a == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        for (int x = 0; x < 128; ++x) {
            byte[] bytes = new byte[131];
            bytes[1] = (byte)x;
            for (int y2 = 0; y2 < 128; ++y2) {
                bytes[y2 + 3] = data.buffer[y2 * 128 + x];
            }
            he packet = new he((int)map.getId(), bytes);
            this.getHandle().a.a((ft)packet);
        }
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        mw entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.K || entity instanceof FakePlayer) {
            return false;
        }
        if (entity.a == null || entity.a.isDisconnected()) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent(this, from, to, cause);
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        this.eject();
        this.leaveVehicle();
        from = event.getFrom();
        to = event.getTo();
        mt fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        mt toWorld = ((CraftWorld)to.getWorld()).getHandle();
        if (this.getHandle().bo != this.getHandle().bn) {
            this.getHandle().k();
        }
        if (fromWorld == toWorld) {
            entity.a.teleport(to);
        } else {
            this.getHandle().a(null);
            ThermiteTeleportationHandler.transferPlayerToDimension(this.getHandle(), toWorld.dimension, this.getHandle().b.ah(), to.getWorld().getEnvironment());
            this.getHandle().a.teleport(to);
        }
        return true;
    }

    @Override
    public boolean isSneaking() {
        return this.getHandle().an();
    }

    @Override
    public void setSneaking(boolean sneak) {
        this.getHandle().b(sneak);
    }

    @Override
    public boolean isSprinting() {
        return this.getHandle().ao();
    }

    @Override
    public void setSprinting(boolean sprinting) {
        this.getHandle().c(sprinting);
    }

    @Override
    public void loadData() {
        this.server.getHandle().o.b((yz)this.getHandle());
    }

    @Override
    public void saveData() {
        this.server.getHandle().o.a((yz)this.getHandle());
    }

    @Override
    @Deprecated
    public void updateInventory() {
        this.getHandle().a(this.getHandle().bo);
    }

    @Override
    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    @Override
    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().checkSleepStatus();
    }

    @Override
    public void awardAchievement(Achievement achievement) {
        Validate.notNull((Object)((Object)achievement), (String)"Achievement cannot be null");
        if (achievement.hasParent() && !this.hasAchievement(achievement.getParent())) {
            this.awardAchievement(achievement.getParent());
        }
        this.getHandle().w().a((yz)this.getHandle(), (ph)CraftStatistic.getNMSAchievement(achievement), 1);
        this.getHandle().w().b(this.getHandle());
    }

    @Override
    public void removeAchievement(Achievement achievement) {
        Validate.notNull((Object)((Object)achievement), (String)"Achievement cannot be null");
        for (Achievement achieve : Achievement.values()) {
            if (achieve.getParent() != achievement || !this.hasAchievement(achieve)) continue;
            this.removeAchievement(achieve);
        }
        this.getHandle().w().a((yz)this.getHandle(), (ph)CraftStatistic.getNMSAchievement(achievement), 0);
    }

    @Override
    public boolean hasAchievement(Achievement achievement) {
        Validate.notNull((Object)((Object)achievement), (String)"Achievement cannot be null");
        return this.getHandle().w().a(CraftStatistic.getNMSAchievement(achievement));
    }

    @Override
    public void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1);
    }

    @Override
    public void decrementStatistic(Statistic statistic) {
        this.decrementStatistic(statistic, 1);
    }

    @Override
    public int getStatistic(Statistic statistic) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (String)"Must supply additional paramater for this statistic");
        return this.getHandle().w().a(CraftStatistic.getNMSStatistic(statistic));
    }

    @Override
    public void incrementStatistic(Statistic statistic, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, this.getStatistic(statistic) + amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, this.getStatistic(statistic) - amount);
    }

    @Override
    public void setStatistic(Statistic statistic, int newValue) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (String)"Must supply additional paramater for this statistic");
        Validate.isTrue((newValue >= 0 ? 1 : 0) != 0, (String)"Value must be greater than or equal to 0");
        ph nmsStatistic = CraftStatistic.getNMSStatistic(statistic);
        this.getHandle().w().a((yz)this.getHandle(), nmsStatistic, newValue);
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material) {
        this.incrementStatistic(statistic, material, 1);
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material) {
        this.decrementStatistic(statistic, material, 1);
    }

    @Override
    public int getStatistic(Statistic statistic, Material material) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (String)"This statistic does not take a Material parameter");
        ph nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied Material does not have a corresponding statistic");
        return this.getHandle().w().a(nmsStatistic);
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, material, this.getStatistic(statistic, material) + amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, material, this.getStatistic(statistic, material) - amount);
    }

    @Override
    public void setStatistic(Statistic statistic, Material material, int newValue) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        Validate.isTrue((newValue >= 0 ? 1 : 0) != 0, (String)"Value must be greater than or equal to 0");
        Validate.isTrue((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (String)"This statistic does not take a Material parameter");
        ph nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied Material does not have a corresponding statistic");
        this.getHandle().w().a((yz)this.getHandle(), nmsStatistic, newValue);
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        this.incrementStatistic(statistic, entityType, 1);
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        this.decrementStatistic(statistic, entityType, 1);
    }

    @Override
    public int getStatistic(Statistic statistic, EntityType entityType) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.notNull((Object)((Object)entityType), (String)"EntityType cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (String)"This statistic does not take an EntityType parameter");
        ph nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied EntityType does not have a corresponding statistic");
        return this.getHandle().w().a(nmsStatistic);
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, entityType, this.getStatistic(statistic, entityType) + amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, entityType, this.getStatistic(statistic, entityType) - amount);
    }

    @Override
    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.notNull((Object)((Object)entityType), (String)"EntityType cannot be null");
        Validate.isTrue((newValue >= 0 ? 1 : 0) != 0, (String)"Value must be greater than or equal to 0");
        Validate.isTrue((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (String)"This statistic does not take an EntityType parameter");
        ph nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied EntityType does not have a corresponding statistic");
        this.getHandle().w().a((yz)this.getHandle(), nmsStatistic, newValue);
    }

    @Override
    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    @Override
    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    @Override
    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    @Override
    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    @Override
    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    @Override
    public WeatherType getPlayerWeather() {
        return this.getHandle().getPlayerWeather();
    }

    @Override
    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    @Override
    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    @Override
    public boolean isBanned() {
        return this.server.getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    @Override
    public void setBanned(boolean value) {
        if (value) {
            this.server.getBanList(BanList.Type.NAME).addBan(this.getName(), null, null, null);
        } else {
            this.server.getBanList(BanList.Type.NAME).pardon(this.getName());
        }
    }

    @Override
    public boolean isWhitelisted() {
        return this.server.getHandle().e(this.getProfile());
    }

    @Override
    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().d(this.getProfile());
        } else {
            this.server.getHandle().c(this.getProfile());
        }
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue(this.getHandle().c.b().a());
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (this.getHandle().a == null) {
            return;
        }
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        if (mode != this.getGameMode()) {
            PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this, mode);
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return;
            }
            this.getHandle().c.a(ahk.a((int)mode.getValue()));
            this.getHandle().R = 0.0f;
            this.getHandle().a.a((ft)new gv(3, (float)mode.getValue()));
        }
    }

    @Override
    public void giveExp(int exp) {
        this.getHandle().v(exp);
    }

    @Override
    public void giveExpLevels(int levels) {
        this.getHandle().a(levels);
    }

    @Override
    public float getExp() {
        return this.getHandle().bH;
    }

    @Override
    public void setExp(float exp) {
        this.getHandle().bH = exp;
        this.getHandle().bT = -1;
    }

    @Override
    public int getLevel() {
        return this.getHandle().bF;
    }

    @Override
    public void setLevel(int level) {
        this.getHandle().bF = level;
        this.getHandle().bT = -1;
    }

    @Override
    public int getTotalExperience() {
        return this.getHandle().bG;
    }

    @Override
    public void setTotalExperience(int exp) {
        this.getHandle().bG = exp;
    }

    @Override
    public float getExhaustion() {
        return this.getHandle().bQ().c;
    }

    @Override
    public void setExhaustion(float value) {
        this.getHandle().bQ().c = value;
    }

    @Override
    public float getSaturation() {
        return this.getHandle().bQ().b;
    }

    @Override
    public void setSaturation(float value) {
        this.getHandle().bQ().b = value;
    }

    @Override
    public int getFoodLevel() {
        return this.getHandle().bQ().a;
    }

    @Override
    public void setFoodLevel(int value) {
        this.getHandle().bQ().a = value;
    }

    @Override
    public Location getBedSpawnLocation() {
        World world = this.getServer().getWorld(this.getHandle().spawnWorld);
        r bed = this.getHandle().bN();
        if (world != null && bed != null && (bed = yz.a((ahb)((CraftWorld)world).getHandle(), (r)bed, (boolean)this.getHandle().bO())) != null) {
            return new Location(world, bed.a, bed.b, bed.c);
        }
        return null;
    }

    @Override
    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    @Override
    public void setBedSpawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().a(null, override);
        } else {
            this.getHandle().a(new r(location.getBlockX(), location.getBlockY(), location.getBlockZ()), override);
            this.getHandle().spawnWorld = location.getWorld().getName();
        }
    }

    @Override
    public void hidePlayer(Player player) {
        Validate.notNull((Object)player, (String)"hidden player cannot be null");
        if (this.getHandle().a == null) {
            return;
        }
        if (this.equals(player)) {
            return;
        }
        if (this.hiddenPlayers.contains(player.getUniqueId())) {
            return;
        }
        this.hiddenPlayers.add(player.getUniqueId());
        mn tracker = ((mt)this.entity.o).K;
        mw other = ((CraftPlayer)player).getHandle();
        my entry = (my)tracker.d.a(other.y());
        if (entry != null) {
            entry.c(this.getHandle());
        }
        this.getHandle().a.a((ft)new ho(player.getPlayerListName(), false, 9999));
    }

    @Override
    public void showPlayer(Player player) {
        Validate.notNull((Object)player, (String)"shown player cannot be null");
        if (this.getHandle().a == null) {
            return;
        }
        if (this.equals(player)) {
            return;
        }
        if (!this.hiddenPlayers.contains(player.getUniqueId())) {
            return;
        }
        this.hiddenPlayers.remove(player.getUniqueId());
        mn tracker = ((mt)this.entity.o).K;
        mw other = ((CraftPlayer)player).getHandle();
        my entry = (my)tracker.d.a(other.y());
        if (entry != null) {
            entry.c(this.getHandle());
        }
        this.getHandle().a.a((ft)new ho(player.getPlayerListName(), false, 9999));
    }

    public void removeDisconnectingPlayer(Player player) {
        this.hiddenPlayers.remove(player.getUniqueId());
    }

    @Override
    public boolean canSee(Player player) {
        return !this.hiddenPlayers.contains(player.getUniqueId());
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    @Override
    public Player getPlayer() {
        return this;
    }

    public mw getHandle() {
        return (mw)this.entity;
    }

    public void setHandle(mw entity) {
        super.setHandle((yz)entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + '}';
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getName() != null ? this.getName().toLowerCase().hashCode() : 0);
        }
        return this.hash;
    }

    @Override
    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    @Override
    public long getLastPlayed() {
        return this.lastPlayed;
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public void readExtraData(dh nbttagcompound) {
        this.hasPlayedBefore = true;
        if (nbttagcompound.c("bukkit")) {
            dh data = nbttagcompound.m("bukkit");
            if (data.c("firstPlayed")) {
                this.firstPlayed = data.g("firstPlayed");
                this.lastPlayed = data.g("lastPlayed");
            }
            if (data.c("newExp")) {
                mw handle = this.getHandle();
                handle.newExp = data.f("newExp");
                handle.newTotalExp = data.f("newTotalExp");
                handle.newLevel = data.f("newLevel");
                handle.expToDrop = data.f("expToDrop");
                handle.keepLevel = data.n("keepLevel");
            }
        }
    }

    public void setExtraData(dh nbttagcompound) {
        if (!nbttagcompound.c("bukkit")) {
            nbttagcompound.a("bukkit", (dy)new dh());
        }
        dh data = nbttagcompound.m("bukkit");
        mw handle = this.getHandle();
        data.a("newExp", handle.newExp);
        data.a("newTotalExp", handle.newTotalExp);
        data.a("newLevel", handle.newLevel);
        data.a("expToDrop", handle.expToDrop);
        data.a("keepLevel", handle.keepLevel);
        data.a("firstPlayed", this.getFirstPlayed());
        data.a("lastPlayed", System.currentTimeMillis());
        data.a("lastKnownName", handle.b_());
    }

    @Override
    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    @Override
    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, new ManuallyAbandonedConversationCanceller()));
    }

    @Override
    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    @Override
    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    @Override
    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.server.getMessenger(), source, channel, message);
        if (this.getHandle().a == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            gr packet = new gr(channel, message);
            this.getHandle().a.a((ft)packet);
        }
    }

    @Override
    public void setTexturePack(String url) {
        this.setResourcePack(url);
    }

    @Override
    public void setResourcePack(String url) {
        Validate.notNull((Object)url, (String)"Resource pack URL cannot be null");
        this.getHandle().a(url);
    }

    public void addChannel(String channel) {
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent(new PlayerRegisterChannelEvent((Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel)) {
            this.server.getPluginManager().callEvent(new PlayerUnregisterChannelEvent((Player)this, channel));
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().a == null) {
            return;
        }
        Set<String> listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes(StandardCharsets.UTF_8));
                    stream.write(0);
                }
                catch (IOException ex) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            this.getHandle().a.a((ft)new gr("REGISTER", stream.toByteArray()));
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        zs container = this.getHandle().bo;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        this.getHandle().a(container, prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    @Override
    public boolean isFlying() {
        return this.getHandle().bE.b;
    }

    @Override
    public void setFlying(boolean value) {
        if (!this.getAllowFlight() && value) {
            throw new IllegalArgumentException("Cannot make player fly if getAllowFlight() is false");
        }
        this.getHandle().bE.b = value;
        this.getHandle().q();
    }

    @Override
    public boolean getAllowFlight() {
        return this.getHandle().bE.c;
    }

    @Override
    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().bE.b = false;
        }
        this.getHandle().bE.c = value;
        this.getHandle().q();
    }

    @Override
    public int getNoDamageTicks() {
        if (this.getHandle().bU > 0) {
            return Math.max(this.getHandle().bU, this.getHandle().ad);
        }
        return this.getHandle().ad;
    }

    @Override
    public float getFlySpeed() {
        return this.getHandle().bE.f * 2.0f;
    }

    @Override
    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        mw player = this.getHandle();
        player.bE.f = Math.max(value, 1.0E-4f) / 2.0f;
        player.q();
    }

    @Override
    public float getWalkSpeed() {
        return this.getHandle().bE.g * 2.0f;
    }

    @Override
    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        mw player = this.getHandle();
        player.bE.g = Math.max(value, 1.0E-4f) / 2.0f;
        player.q();
    }

    private void validateSpeed(float value) {
        if (value < 0.0f) {
            if (value < -1.0f) {
                throw new IllegalArgumentException(value + " is too low");
            }
        } else if (value > 1.0f) {
            throw new IllegalArgumentException(value + " is too high");
        }
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, this.health);
        this.getHandle().o();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().o();
    }

    @Override
    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        Validate.notNull((Object)scoreboard, (String)"Scoreboard cannot be null");
        nh playerConnection = this.getHandle().a;
        if (playerConnection == null) {
            throw new IllegalStateException("Cannot set scoreboard yet");
        }
        if (playerConnection.isDisconnected()) {
            // empty if block
        }
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    @Override
    public double getHealthScale() {
        return this.healthScale;
    }

    @Override
    public void setHealthScale(double value) {
        Validate.isTrue(((float)value > 0.0f ? 1 : 0) != 0, (String)"Must be greater than 0");
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    @Override
    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    @Override
    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        this.health = health;
    }

    public void updateScaledHealth() {
        tq attributemapserver = (tq)this.getHandle().bc();
        Set set = attributemapserver.b();
        this.injectScaledMaxHealth(set, true);
        this.getHandle().z().b(6, (Object)Float.valueOf(this.getScaledHealth()));
        this.getHandle().a.a((ft)new ib(this.getScaledHealth(), this.getHandle().bQ().a(), this.getHandle().bQ().e()));
        this.getHandle().a.a((ft)new il(this.getHandle().y(), (Collection)set));
        set.clear();
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    public void injectScaledMaxHealth(Collection collection, boolean force) {
        if (!this.scaledHealth && !force) {
            return;
        }
        for (Object genericInstance : collection) {
            th attribute = ((ti)genericInstance).a();
            if (!attribute.a().equals("generic.maxHealth")) continue;
            collection.remove(genericInstance);
            break;
        }
        collection.add(new tn(this.getHandle().bc(), (th)new to("generic.maxHealth", this.scaledHealth ? this.healthScale : this.getMaxHealth(), 0.0, 3.4028234663852886E38).a("Max Health").a(true)));
    }

    @Override
    public Player.Spigot spigot() {
        return this.spigot;
    }

    @Override
    public void sendTitle(String title, String subtitle) {
        throw new UnsupportedOperationException("This method requires Crucible NecroTempus to work, you can get it at https://github.com/CrucibleMC/NecroTempus.");
    }

    @Override
    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        throw new UnsupportedOperationException("This method requires Crucible NecroTempus to work, you can get it at https://github.com/CrucibleMC/NecroTempus.");
    }

    @Override
    public void resetTitle() {
        throw new UnsupportedOperationException("This method requires Crucible NecroTempus to work, you can get it at https://github.com/CrucibleMC/NecroTempus.");
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y2, double z2, int count) {
        this.spawnParticle(particle, x, y2, z2, count, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y2, double z2, int count, T data) {
        this.spawnParticle(particle, x, y2, z2, count, 0.0, 0.0, 0.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y2, z2, count, offsetX, offsetY, offsetZ, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y2, z2, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y2, z2, count, offsetX, offsetY, offsetZ, extra, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + particle.getDataType() + " got " + data.getClass());
        }
        try {
            MinecraftParticles minecraftParticles = CraftParticle.toNMS(particle);
            String name = minecraftParticles.getName();
            int[] data_arr = CraftParticle.toData(particle, data);
            if (minecraftParticles.getArgumentCount() >= 1 && !adb.e.b(data_arr[0])) {
                data_arr[0] = 1;
            }
            if (minecraftParticles.getArgumentCount() == 1) {
                name = name + data_arr[0] + "_0";
            } else if (minecraftParticles.getArgumentCount() == 2) {
                name = name + data_arr[0] + "_" + data_arr[1];
            }
            hb s2APacketParticles = new hb(name, (float)x, (float)y2, (float)z2, (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
            this.getHandle().a.a((ft)s2APacketParticles);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getPlayerListHeader() {
        return this.playerListHeaderString;
    }

    @Override
    public String getPlayerListFooter() {
        return this.playerListFooterString;
    }

    @Override
    public void setPlayerListHeader(@Nullable String header) {
        this.playerListHeaderString = header;
        this.setPlayerListHeaderFooter(this.playerListHeaderString, this.playerListFooterString);
    }

    @Override
    public void setPlayerListFooter(@Nullable String footer) {
        this.playerListFooterString = footer;
        this.setPlayerListHeaderFooter(this.playerListHeaderString, this.playerListFooterString);
    }

    @Override
    public void setPlayerListHeaderFooter(String header, String footer) {
        throw new UnsupportedOperationException("This method requires Crucible NecroTempus to work, you can get it at https://github.com/CrucibleMC/NecroTempus.");
    }
}

