/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;

public class PlayerChatTabCompleteEvent
extends PlayerEvent {
    private static final HandlerList handlers = new HandlerList();
    private final String message;
    private final String lastToken;
    private final Collection<String> completions;
    private final boolean isPinging;

    public PlayerChatTabCompleteEvent(Player who, String message, Collection<String> completions) {
        super(who);
        Validate.notNull((Object)message, (String)"Message cannot be null");
        Validate.notNull(completions, (String)"Completions cannot be null");
        this.message = message;
        int i = message.lastIndexOf(32);
        if (i < 0) {
            if (message.length() > 0 && message.charAt(0) == '@') {
                this.lastToken = message.substring(1);
                this.isPinging = true;
            } else {
                this.lastToken = message;
                this.isPinging = false;
            }
        } else {
            String lastToken = message.substring(i + 1);
            if (lastToken.length() > 0 && lastToken.charAt(0) == '@') {
                lastToken = lastToken.length() == 1 ? "" : lastToken.substring(1);
                this.isPinging = true;
            } else {
                this.isPinging = false;
            }
            this.lastToken = lastToken;
        }
        this.completions = completions;
    }

    public boolean isPinging() {
        return this.isPinging;
    }

    public String getChatMessage() {
        return this.message;
    }

    public String getLastToken() {
        return this.lastToken;
    }

    public Collection<String> getTabCompletions() {
        return this.completions;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

