/*
 * Decompiled with CFR 0.152.
 */
package thermos.wrapper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ThermiteMap
implements Map {
    private final HashMap<Integer, Object[][]> map = new HashMap();
    private final HashMap<Object, Object> original = new HashMap();
    private int size = 0;

    public ThermiteMap() {
        for (int i = 0; i <= 256; ++i) {
            this.map.put(i, new Object[16][16]);
        }
    }

    public static boolean isValid(Object o) {
        return o instanceof agt;
    }

    public static int[] getCoords(Object o) {
        agt cp = (agt)o;
        return new int[]{cp.a, cp.b, cp.c};
    }

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!ThermiteMap.isValid(key)) {
            return false;
        }
        int[] coords = ThermiteMap.getCoords(key);
        return this.map.get(coords[1])[coords[0]][coords[2]] != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.original.containsValue(value);
    }

    public Object get(Object key) {
        if (!ThermiteMap.isValid(key)) {
            return null;
        }
        int[] coords = ThermiteMap.getCoords(key);
        return this.map.get(coords[1])[coords[0]][coords[2]];
    }

    public Object put(Object key, Object value) {
        if (!ThermiteMap.isValid(key)) {
            return null;
        }
        int[] coords = ThermiteMap.getCoords(key);
        Object instance = this.original.put(key, value);
        this.map.get((Object)Integer.valueOf((int)coords[1]))[coords[0]][coords[2]] = value;
        ++this.size;
        return instance;
    }

    public Object remove(Object key) {
        if (!ThermiteMap.isValid(key)) {
            return null;
        }
        int[] coords = ThermiteMap.getCoords(key);
        Object instance = this.original.remove(key);
        this.map.get((Object)Integer.valueOf((int)coords[1]))[coords[0]][coords[2]] = null;
        --this.size;
        return instance;
    }

    public void putAll(Map m) {
        this.original.putAll(m);
    }

    @Override
    public void clear() {
        this.original.clear();
        this.map.clear();
    }

    public Set keySet() {
        return this.original.keySet();
    }

    public Collection values() {
        return this.original.values();
    }

    public Set entrySet() {
        return this.original.entrySet();
    }
}

