/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.damask;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import pw.prok.damask.api.ArtifactResolveRequest;
import pw.prok.damask.api.ArtifactResolveResult;
import pw.prok.damask.api.VersionListRequest;
import pw.prok.damask.api.VersionListResult;
import pw.prok.damask.cache.SimpleCache;
import pw.prok.damask.dsl.DefaultRepository;
import pw.prok.damask.dsl.IArtifact;
import pw.prok.damask.dsl.IModule;
import pw.prok.damask.dsl.IRepository;
import pw.prok.damask.internal.job.DamaskExecutor;
import pw.prok.damask.internal.job.DamaskRequest;
import pw.prok.damask.internal.job.DamaskResult;
import pw.prok.damask.utils.Digest;

public class Damask {
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private static final XPath XPATH = XPATH_FACTORY.newXPath();
    private static final SimpleCache<Object> sCache = SimpleCache.memoryCache();
    private static final Damask DEFAULT = new Damask();
    private static File sTempDirectory;
    private List<IRepository> mRepositories = new LinkedList<IRepository>();

    public static XPath x() {
        return XPATH;
    }

    public static File temp(String id) {
        if (sTempDirectory == null) {
            try {
                File baseDir = new File(System.getProperty("java.io.tmpdir"));
                sTempDirectory = new File(baseDir, "damask-" + new Random().nextLong() + "-" + System.nanoTime());
                if (!sTempDirectory.mkdirs()) {
                    throw new IOException("Could not create directory set");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Sometimes we can create directories. Sometimes not. It's not your day buddy.", e);
            }
        }
        File f = new File(sTempDirectory, Digest.toHex(Digest.sha1(id)));
        f.mkdirs();
        return f;
    }

    public static File temp(Object id) {
        return Damask.temp(String.valueOf(System.identityHashCode(id)));
    }

    public static Damask get() {
        return DEFAULT;
    }

    public Damask addRepository(IRepository repository) {
        this.mRepositories.add(repository);
        return this;
    }

    public Damask addRepository(String name, String url) {
        return this.addRepository(new DefaultRepository(name, url));
    }

    public List<IRepository> repositories() {
        return Collections.unmodifiableList(this.mRepositories);
    }

    public <Request extends DamaskRequest<Result>, Result extends DamaskResult<Result>> Result execute(Request request) {
        return DamaskExecutor.execute(request, this);
    }

    public VersionListResult versionList(IModule module) {
        return (VersionListResult)this.execute(new VersionListRequest(module));
    }

    public ArtifactResolveResult artifactResolve(IArtifact artifact, File targetFile, boolean autoname) {
        return (ArtifactResolveResult)this.execute(new ArtifactResolveRequest(artifact, targetFile, autoname));
    }

    public ArtifactResolveResult artifactResolve(IArtifact artifact) {
        return (ArtifactResolveResult)this.execute(new ArtifactResolveRequest(artifact, null, true));
    }
}

