/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.damask.api;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import pw.prok.damask.comparators.ModuleVersionComparator;
import pw.prok.damask.dsl.IModuleVersion;
import pw.prok.damask.internal.job.DamaskResult;

public class VersionListResult
extends DamaskResult<VersionListResult> {
    private static final Comparator<IModuleVersion> LATEST_VERSION = ModuleVersionComparator.INSTANCE;
    private List<IModuleVersion> mVersions;

    public VersionListResult(List<IModuleVersion> versions) {
        this.mVersions = versions;
        Collections.sort(this.mVersions, ModuleVersionComparator.INSTANCE);
    }

    public List<IModuleVersion> getVersions() {
        return this.mVersions;
    }

    public IModuleVersion getLatestVersion() {
        return Collections.max(this.mVersions, LATEST_VERSION);
    }

    public IModuleVersion getFirstVersion() {
        return Collections.min(this.mVersions, LATEST_VERSION);
    }

    @Override
    public VersionListResult merge(VersionListResult result) {
        this.mVersions.addAll(result.mVersions);
        return this;
    }

    public String toString() {
        return this.mVersions.toString();
    }
}

