/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.damask.dsl;

import java.util.Arrays;

public final class Version
implements Comparable<Version> {
    private final String mRawVersion;
    private final String[] mRawTokens;
    private final int[] mVersionTokens;
    private final boolean[] mUpVersion;
    private final boolean mSpecified;
    private final String mSnapshotVersion;
    private final String mFinalSnapshotVersion;

    public Version(String version) {
        this.mRawVersion = version;
        this.mRawTokens = version.split("\\.|-|_");
        this.mVersionTokens = new int[this.mRawTokens.length];
        this.mUpVersion = new boolean[this.mRawTokens.length];
        Arrays.fill(this.mVersionTokens, 0);
        Arrays.fill(this.mUpVersion, false);
        boolean specified = true;
        for (int i = 0; i < this.mRawTokens.length; ++i) {
            String token = this.mRawTokens[i];
            if (token.endsWith("+")) {
                this.mUpVersion[i] = true;
                specified = false;
                token = token.substring(0, token.length() - 1);
            }
            try {
                this.mVersionTokens[i] = Integer.parseInt(token);
                continue;
            }
            catch (NumberFormatException ignored) {
                this.mVersionTokens[i] = Integer.MIN_VALUE;
            }
        }
        this.mSnapshotVersion = null;
        this.mFinalSnapshotVersion = null;
        this.mSpecified = specified;
    }

    public Version(Version version) {
        this(version, null);
    }

    private Version(Version version, String snapshotVersion) {
        this.mRawVersion = version.mRawVersion;
        this.mRawTokens = version.mRawTokens;
        this.mVersionTokens = version.mVersionTokens;
        this.mUpVersion = version.mUpVersion;
        this.mSpecified = version.mSpecified;
        String string = this.mSnapshotVersion = snapshotVersion == null ? version.mSnapshotVersion : snapshotVersion;
        if (this.mSnapshotVersion != null) {
            if (!this.mRawVersion.endsWith("-SNAPSHOT")) {
                throw new IllegalStateException("Current version (" + this.mRawVersion + ") isn't snapshot!");
            }
            this.mFinalSnapshotVersion = this.mRawVersion.substring(0, this.mRawVersion.length() - "SNAPSHOT".length()) + this.mSnapshotVersion;
        } else {
            this.mFinalSnapshotVersion = null;
        }
    }

    @Override
    public int compareTo(Version version) {
        int l1 = this.mVersionTokens.length;
        int l2 = version.mVersionTokens.length;
        int maxTokens = Math.max(l1, l2);
        for (int i = 0; i < maxTokens; ++i) {
            int t2;
            int t1 = i < l1 ? this.mVersionTokens[i] : 0;
            int n = t2 = i < l2 ? version.mVersionTokens[i] : 0;
            if (t1 < t2) {
                return -1;
            }
            if (t1 > t2) {
                return 1;
            }
            int c = this.mRawTokens[i].compareTo(version.mRawTokens[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public boolean isMatching(Version version) {
        int l1 = this.mVersionTokens.length;
        int l2 = version.mVersionTokens.length;
        int maxTokens = Math.max(l1, l2);
        for (int i = 0; i < maxTokens; ++i) {
            boolean p2;
            int t1 = i < l1 ? this.mVersionTokens[i] : 0;
            boolean p1 = i >= l1 || this.mUpVersion[i];
            int t2 = i < l2 ? version.mVersionTokens[i] : 0;
            boolean bl = p2 = i >= l2 || version.mUpVersion[i];
            if (t1 == t2 && !p2 || p1 && t1 < t2) continue;
            return false;
        }
        return true;
    }

    public boolean isSpecified() {
        return this.mSpecified;
    }

    public boolean isSnapshot() {
        return this.mRawVersion.endsWith("-SNAPSHOT");
    }

    public String toString() {
        if (this.mFinalSnapshotVersion != null) {
            return this.mRawVersion + '[' + this.mFinalSnapshotVersion + ']';
        }
        return this.mRawVersion;
    }

    public int hashCode() {
        return this.mRawVersion.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version version = (Version)obj;
        return this.mRawVersion.equals(version.mRawVersion);
    }

    public Version resolveSnapshot(String timestamp, String buildNumber) {
        return this.resolveSnapshot(timestamp + '-' + buildNumber);
    }

    public Version resolveSnapshot(String snapshotVersion) {
        return new Version(this, snapshotVersion);
    }

    public String toRawString() {
        return this.mRawVersion;
    }

    public String toSnapshotString() {
        return this.mFinalSnapshotVersion != null ? this.mFinalSnapshotVersion : this.mRawVersion;
    }
}

