/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.damask.internal.job;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import pw.prok.damask.internal.job.DamaskResult;

public class ResultMerger<Result extends DamaskResult<Result>> {
    private final int mMaxTicks;
    private Result mResult;
    private Lock mLock = new ReentrantLock();
    private AtomicInteger mTicks = new AtomicInteger();

    public ResultMerger(int maxTicks) {
        this.mMaxTicks = maxTicks;
    }

    public void addResult(Result result) {
        this.mLock.lock();
        try {
            if (this.mResult == null) {
                this.mResult = result;
            } else if (result != null) {
                ((DamaskResult)this.mResult).merge(result);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void tick() {
        this.mLock.lock();
        try {
            this.mTicks.incrementAndGet();
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean ready() {
        return this.mTicks.get() == this.mMaxTicks;
    }

    public Result result() {
        return this.mResult;
    }
}

