/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.asm;

import pw.prok.imagine.api.Pair;
import pw.prok.imagine.api.Triple;
import pw.prok.imagine.asm.FieldDesc;
import pw.prok.imagine.asm.ImagineRemapper;
import pw.prok.imagine.asm.MethodDesc;

public enum Mapping {
    OBF{

        @Override
        public String clazz(String name) {
            for (Pair<String, String> mapping : ImagineRemapper.clazz()) {
                if (!name.equals(mapping.first()) && !name.equals(mapping.second())) continue;
                return mapping.first();
            }
            return name;
        }

        @Override
        public FieldDesc field(String owner, String name) {
            String obfOwner = OBF.clazz(owner);
            String srgOwner = SRG.clazz(owner);
            for (Triple<FieldDesc, FieldDesc, FieldDesc> mapping : ImagineRemapper.fields()) {
                if (!((FieldDesc)mapping.first()).equals(obfOwner, name) && !((FieldDesc)mapping.second()).equals(srgOwner, name) && !mapping.third().equals(srgOwner, name)) continue;
                return (FieldDesc)mapping.first();
            }
            return new FieldDesc(obfOwner, name);
        }

        @Override
        public MethodDesc method(String owner, String name, String desc) {
            String obfOwner = OBF.clazz(owner);
            String obfDesc = ImagineRemapper.descObf(desc);
            String srgOwner = SRG.clazz(owner);
            String srgDesc = ImagineRemapper.descSrg(desc);
            for (Triple<MethodDesc, MethodDesc, MethodDesc> mapping : ImagineRemapper.methods()) {
                if (!((MethodDesc)mapping.first()).equals(obfOwner, name, obfDesc) && !((MethodDesc)mapping.second()).equals(srgOwner, name, srgDesc) && !mapping.third().equals(srgOwner, name, srgDesc)) continue;
                return (MethodDesc)mapping.first();
            }
            return new MethodDesc(obfOwner, name, obfDesc);
        }
    }
    ,
    SRG{

        @Override
        public String clazz(String name) {
            for (Pair<String, String> mapping : ImagineRemapper.clazz()) {
                if (!name.equals(mapping.first()) && !name.equals(mapping.second())) continue;
                return mapping.second();
            }
            return name;
        }

        @Override
        public FieldDesc field(String owner, String name) {
            String obfOwner = OBF.clazz(owner);
            String srgOwner = SRG.clazz(owner);
            for (Triple<FieldDesc, FieldDesc, FieldDesc> mapping : ImagineRemapper.fields()) {
                if (!((FieldDesc)mapping.first()).equals(obfOwner, name) && !((FieldDesc)mapping.second()).equals(srgOwner, name) && !mapping.third().equals(srgOwner, name)) continue;
                return (FieldDesc)mapping.second();
            }
            return new FieldDesc(srgOwner, name);
        }

        @Override
        public MethodDesc method(String owner, String name, String desc) {
            String obfOwner = OBF.clazz(owner);
            String obfDesc = ImagineRemapper.descObf(desc);
            String srgOwner = SRG.clazz(owner);
            String srgDesc = ImagineRemapper.descSrg(desc);
            for (Triple<MethodDesc, MethodDesc, MethodDesc> mapping : ImagineRemapper.methods()) {
                if (!((MethodDesc)mapping.first()).equals(obfOwner, name, obfDesc) && !((MethodDesc)mapping.second()).equals(srgOwner, name, srgDesc) && !mapping.third().equals(srgOwner, name, srgDesc)) continue;
                return (MethodDesc)mapping.second();
            }
            return new MethodDesc(srgOwner, name, srgDesc);
        }
    }
    ,
    DEV{

        @Override
        public String clazz(String name) {
            return SRG.clazz(name);
        }

        @Override
        public FieldDesc field(String owner, String name) {
            String obfOwner = OBF.clazz(owner);
            String srgOwner = SRG.clazz(owner);
            for (Triple<FieldDesc, FieldDesc, FieldDesc> mapping : ImagineRemapper.fields()) {
                if (!((FieldDesc)mapping.first()).equals(obfOwner, name) && !((FieldDesc)mapping.second()).equals(srgOwner, name) && !mapping.third().equals(srgOwner, name)) continue;
                return mapping.third();
            }
            return new FieldDesc(srgOwner, name);
        }

        @Override
        public MethodDesc method(String owner, String name, String desc) {
            String obfOwner = OBF.clazz(owner);
            String obfDesc = ImagineRemapper.descObf(desc);
            String srgOwner = SRG.clazz(owner);
            String srgDesc = ImagineRemapper.descSrg(desc);
            for (Triple<MethodDesc, MethodDesc, MethodDesc> mapping : ImagineRemapper.methods()) {
                if (!((MethodDesc)mapping.first()).equals(obfOwner, name, obfDesc) && !((MethodDesc)mapping.second()).equals(srgOwner, name, srgDesc) && !mapping.third().equals(srgOwner, name, srgDesc)) continue;
                return mapping.third();
            }
            return new MethodDesc(srgOwner, name, srgDesc);
        }
    };


    public abstract String clazz(String var1);

    public abstract FieldDesc field(String var1, String var2);

    public abstract MethodDesc method(String var1, String var2, String var3);
}

