/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.asm;

import java.util.Iterator;
import org.objectweb.asm.tree.MethodNode;
import pw.prok.imagine.asm.Filter;
import pw.prok.imagine.asm.ImagineASM;
import pw.prok.imagine.asm.ImagineMethod;

public class MethodFilter
implements Iterable<ImagineMethod> {
    private final ImagineASM mAsm;
    private final Filter mFilter;

    public MethodFilter(ImagineASM asm, Filter filter) {
        this.mAsm = asm;
        this.mFilter = filter;
    }

    @Override
    public Iterator<ImagineMethod> iterator() {
        this.mAsm.readClass();
        return new MethodIterator(this, this.mAsm.mClassNode.methods.iterator());
    }

    private static class MethodIterator
    implements Iterator<ImagineMethod> {
        private final MethodFilter mFilter;
        private final Iterator<MethodNode> mIterator;
        private ImagineMethod mMethod;

        public MethodIterator(MethodFilter filter, Iterator<MethodNode> iterator) {
            this.mFilter = filter;
            this.mIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            this.mMethod = null;
            while (this.mIterator.hasNext()) {
                MethodNode node = this.mIterator.next();
                ImagineMethod method = new ImagineMethod(this.mFilter.mAsm, node);
                if (!this.mFilter.mFilter.matching(method)) continue;
                this.mMethod = method;
            }
            return this.mIterator.hasNext();
        }

        @Override
        public ImagineMethod next() {
            if (this.mMethod == null) {
                this.hasNext();
            }
            ImagineMethod method = this.mMethod;
            this.mMethod = null;
            return method;
        }

        @Override
        public void remove() {
            this.mIterator.remove();
        }
    }
}

