/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import pw.prok.imagine.reflect.IClassScanCallback;
import pw.prok.imagine.reflect.IFilter;
import pw.prok.imagine.reflect.IScanner;
import pw.prok.imagine.reflect.ImagineReflect;

public class AnnotationFilter<A extends Annotation>
implements IFilter {
    public static final int FILTER_CLASS = 1;
    public static final int FILTER_FIELDS = 2;
    public static final int FILTER_METHODS = 4;
    private final Class<A> mAnnotationClass;
    private final boolean mFilterClass;
    private final boolean mFilterFields;
    private final boolean mFilterMethods;
    private final Filter<A> mAnnotationFilter;

    public AnnotationFilter(Class<A> clazz, Filter<A> filter, int flags) {
        this.mAnnotationClass = clazz;
        this.mAnnotationFilter = filter;
        this.mFilterClass = (flags & 1) != 0;
        this.mFilterFields = (flags & 2) != 0;
        this.mFilterMethods = (flags & 4) != 0;
    }

    @Override
    public <S> IFilter.FilterResult filterClass(IScanner scanner, Class<S> mainClass) {
        final AtomicBoolean result = new AtomicBoolean(false);
        if (this.mFilterClass) {
            ImagineReflect.create().scanClass(mainClass, new IClassScanCallback<S>(){

                @Override
                public void scanClass(Class<S> mainClass, Class<? super S> childClass) {
                    Object annotation = childClass.getAnnotation(AnnotationFilter.this.mAnnotationClass);
                    if (annotation != null && (AnnotationFilter.this.mAnnotationFilter == null || AnnotationFilter.this.mAnnotationFilter.classCheckAnnotation(childClass, annotation))) {
                        result.set(true);
                    }
                }
            });
            return IFilter.FilterResult.present(result.get());
        }
        return IFilter.FilterResult.Default;
    }

    @Override
    public <S> IFilter.FilterResult filterField(IScanner scanner, Class<S> mainClass, Class<? super S> childClass, Field field) {
        if (this.mFilterFields) {
            A annotation = field.getAnnotation(this.mAnnotationClass);
            return IFilter.FilterResult.present(annotation != null && (this.mAnnotationFilter == null || this.mAnnotationFilter.fieldCheckAnnotation(field, annotation)));
        }
        return IFilter.FilterResult.Default;
    }

    @Override
    public <S> IFilter.FilterResult filterMethod(IScanner scanner, Class<S> mainClass, Class<? super S> childClass, Method method) {
        if (this.mFilterMethods) {
            A annotation = method.getAnnotation(this.mAnnotationClass);
            return IFilter.FilterResult.present(annotation != null && (this.mAnnotationFilter == null || this.mAnnotationFilter.methodCheckAnnotation(method, annotation)));
        }
        return IFilter.FilterResult.Default;
    }

    public static abstract class Filter<A extends Annotation> {
        public boolean fieldCheckAnnotation(Field field, A annotation) {
            return true;
        }

        public boolean methodCheckAnnotation(Method method, A annotation) {
            return true;
        }

        public boolean classCheckAnnotation(Class<?> clazz, A annotation) {
            return true;
        }
    }
}

