/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import pw.prok.imagine.reflect.AnnotationFilter;
import pw.prok.imagine.reflect.GetSetMethodFilter;
import pw.prok.imagine.reflect.IClassScanCallback;
import pw.prok.imagine.reflect.IFieldScanCallback;
import pw.prok.imagine.reflect.IFilter;
import pw.prok.imagine.reflect.IMemberScanCallback;
import pw.prok.imagine.reflect.IMethodScanCallback;
import pw.prok.imagine.reflect.IScanner;

public class ImagineReflect
implements IScanner {
    private List<IFilter> mFilters = new LinkedList<IFilter>();

    public static IScanner create() {
        return new ImagineReflect();
    }

    @Override
    public <S> void scanClass(Class<S> clazz, IClassScanCallback<S> callback) {
        if (clazz == null || !this.filterClass(clazz)) {
            return;
        }
        for (Class<S> c = clazz; c != Object.class; c = c.getSuperclass()) {
            callback.scanClass(clazz, c);
        }
    }

    @Override
    public <S> void scanFields(Class<S> clazz, IFieldScanCallback<S> callback) {
        this.scanMembersInternal(clazz, callback, null);
    }

    @Override
    public <S> void scanMethod(Class<S> clazz, IMethodScanCallback<S> callback) {
        this.scanMembersInternal(clazz, null, callback);
    }

    @Override
    public <S> void scanMembers(Class<S> clazz, IMemberScanCallback<S> callback) {
        this.scanMembersInternal(clazz, callback, callback);
    }

    private <S> void scanMembersInternal(Class<S> clazz, final IFieldScanCallback<S> fieldCallback, final IMethodScanCallback<S> methodCallback) {
        this.scanClass(clazz, new IClassScanCallback<S>(){

            @Override
            public void scanClass(Class<S> mainClass, Class<? super S> superClass) {
                if (fieldCallback != null) {
                    for (AccessibleObject accessibleObject : superClass.getDeclaredFields()) {
                        if (!ImagineReflect.this.filterField(mainClass, superClass, (Field)accessibleObject)) continue;
                        fieldCallback.scanField(mainClass, superClass, (Field)accessibleObject);
                    }
                }
                if (methodCallback != null) {
                    for (AccessibleObject accessibleObject : superClass.getDeclaredMethods()) {
                        if (!ImagineReflect.this.filterMethod(mainClass, superClass, (Method)accessibleObject)) continue;
                        methodCallback.scanMethod(mainClass, superClass, (Method)accessibleObject);
                    }
                }
            }
        });
    }

    @Override
    public IScanner addFilter(IFilter filter) {
        this.mFilters.add(filter);
        return this;
    }

    @Override
    public IScanner removeFilter(IFilter filter) {
        this.mFilters.remove(filter);
        return this;
    }

    @Override
    public <A extends Annotation> IScanner addAnnotationFilter(Class<A> annotationClass, AnnotationFilter.Filter<A> filter, boolean filterClass, boolean filterFields, boolean filterMethod) {
        return this.addFilter(new AnnotationFilter<A>(annotationClass, filter, (filterClass ? 1 : 0) | (filterFields ? 2 : 0) | (filterMethod ? 4 : 0)));
    }

    @Override
    public <A extends Annotation> IScanner addAnnotationFilter(Class<A> annotationClass, boolean filterClass, boolean filterFields, boolean filterMethod) {
        return this.addAnnotationFilter(annotationClass, null, filterClass, filterFields, filterMethod);
    }

    @Override
    public <A extends Annotation> IScanner withClassAnnotation(Class<A> annotationClass, AnnotationFilter.Filter<A> filter) {
        return this.addFilter(new AnnotationFilter<A>(annotationClass, filter, 1));
    }

    @Override
    public <A extends Annotation> IScanner withClassAnnotation(Class<A> annotationClass) {
        return this.withClassAnnotation(annotationClass, null);
    }

    @Override
    public <A extends Annotation> IScanner withFieldAnnotation(Class<A> annotationClass, AnnotationFilter.Filter<A> filter) {
        return this.addFilter(new AnnotationFilter<A>(annotationClass, filter, 2));
    }

    @Override
    public <A extends Annotation> IScanner withFieldAnnotation(Class<A> annotationClass) {
        return this.withFieldAnnotation(annotationClass, null);
    }

    @Override
    public <A extends Annotation> IScanner withMethodAnnotation(Class<A> annotationClass, AnnotationFilter.Filter<A> filter) {
        return this.addFilter(new AnnotationFilter<A>(annotationClass, filter, 4));
    }

    @Override
    public <A extends Annotation> IScanner withMethodAnnotation(Class<A> annotationClass) {
        return this.withMethodAnnotation(annotationClass, null);
    }

    @Override
    public IScanner addGetSetFilter(boolean get, boolean set) {
        return this.addFilter(new GetSetMethodFilter(get, set));
    }

    @Override
    public IScanner withGetMethods() {
        return this.addGetSetFilter(true, false);
    }

    @Override
    public IScanner withSetMethods() {
        return this.addGetSetFilter(false, true);
    }

    private <S> boolean filterClass(Class<S> mainClass) {
        for (IFilter filter : this.mFilters) {
            switch (filter.filterClass(this, mainClass)) {
                case Accept: {
                    return true;
                }
                case Reject: {
                    return false;
                }
            }
        }
        return true;
    }

    private <S> boolean filterField(Class<S> mainClass, Class<? super S> superClass, Field field) {
        for (IFilter filter : this.mFilters) {
            switch (filter.filterField(this, mainClass, superClass, field)) {
                case Accept: {
                    return true;
                }
                case Reject: {
                    return false;
                }
            }
        }
        return true;
    }

    private <S> boolean filterMethod(Class<S> mainClass, Class<? super S> superClass, Method method) {
        for (IFilter filter : this.mFilters) {
            switch (filter.filterMethod(this, mainClass, superClass, method)) {
                case Accept: {
                    return true;
                }
                case Reject: {
                    return false;
                }
            }
        }
        return true;
    }
}

