/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalFloatObjMapOps;
import com.koloboke.collect.map.FloatObjMap;
import com.koloboke.function.FloatObjConsumer;
import com.koloboke.function.FloatObjPredicate;
import java.util.Map;

public final class CommonFloatObjMapOps {
    public static boolean containsAllEntries(final InternalFloatObjMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof FloatObjMap) {
            FloatObjMap m2 = (FloatObjMap)another;
            if (m2.valueEquivalence().equals((Object)map.valueEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalFloatObjMapOps) {
                    return ((InternalFloatObjMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new FloatObjPredicate(){

                public boolean test(float a, Object b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Float)e.getKey()).floatValue(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <V> void putAll(final InternalFloatObjMapOps<V> map, Map<? extends Float, ? extends V> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof FloatObjMap) {
            if (another instanceof InternalFloatObjMapOps) {
                ((InternalFloatObjMapOps)another).reversePutAllTo(map);
            } else {
                ((FloatObjMap)another).forEach(new FloatObjConsumer<V>(){

                    public void accept(float key, V value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<Float, V> e : another.entrySet()) {
                map.justPut(e.getKey().floatValue(), e.getValue());
            }
        }
    }

    private CommonFloatObjMapOps() {
    }
}

