/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.set.ObjSet;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class CommonObjCollectionOps {
    public static boolean containsAll(final ObjCollection<?> collection, Collection<?> another) {
        if (collection == another) {
            return true;
        }
        if (another instanceof ObjCollection) {
            ObjCollection c2 = (ObjCollection)another;
            if (collection.equivalence().equals((Object)c2.equivalence())) {
                if (collection instanceof ObjSet && c2 instanceof ObjSet && collection.size() < another.size()) {
                    return false;
                }
                if (c2 instanceof InternalObjCollectionOps) {
                    return ((InternalObjCollectionOps)c2).allContainingIn(collection);
                }
            }
            return c2.forEachWhile(new Predicate(){

                public boolean test(Object value) {
                    return collection.contains(value);
                }
            });
        }
        for (Object o : another) {
            if (collection.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean addAll(ObjCollection<E> collection, Collection<? extends E> another) {
        if (collection == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = collection.sizeAsLong() + Containers.sizeAsLong(another);
        collection.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjCollection) {
            if (another instanceof InternalObjCollectionOps) {
                return ((InternalObjCollectionOps)((Object)another)).reverseAddAllTo(collection);
            }
            class AddAll
            implements Consumer<E> {
                boolean collectionChanged = false;
                final /* synthetic */ ObjCollection val$collection;

                AddAll(ObjCollection objCollection) {
                    this.val$collection = objCollection;
                }

                @Override
                public void accept(E value) {
                    this.collectionChanged |= this.val$collection.add(value);
                }
            }
            AddAll addAll = new AddAll(collection);
            ((ObjCollection)another).forEach((Consumer)addAll);
            return addAll.collectionChanged;
        }
        boolean collectionChanged = false;
        for (E v : another) {
            collectionChanged |= collection.add(v);
        }
        return collectionChanged;
    }

    private CommonObjCollectionOps() {
    }
}

