/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalObjLongMapOps;
import com.koloboke.collect.map.ObjLongMap;
import com.koloboke.function.ObjLongPredicate;
import java.util.Map;
import java.util.function.ObjLongConsumer;

public final class CommonObjLongMapOps {
    public static boolean containsAllEntries(final InternalObjLongMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ObjLongMap) {
            ObjLongMap m2 = (ObjLongMap)another;
            if (m2.keyEquivalence().equals((Object)map.keyEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalObjLongMapOps) {
                    return ((InternalObjLongMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ObjLongPredicate(){

                public boolean test(Object a, long b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(e.getKey(), (Long)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <K> void putAll(final InternalObjLongMapOps<K> map, Map<? extends K, ? extends Long> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjLongMap) {
            if (another instanceof InternalObjLongMapOps) {
                ((InternalObjLongMapOps)another).reversePutAllTo(map);
            } else {
                ((ObjLongMap)another).forEach(new ObjLongConsumer<K>(){

                    @Override
                    public void accept(K key, long value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, Long> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonObjLongMapOps() {
    }
}

