/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.writer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import pw.prok.imagine.inject.Creator;
import pw.prok.imagine.writer.IWritable;

public class WritableBuf
extends PacketBuffer {
    private static final Charset UTF_8 = Charset.forName("utf-8");
    public static final int FLAG_NULL = 2;
    public static final int FLAG_LENGTH_SUPPLIED = 4;
    public static final int FLAG_GENERIC_KEY_SUPPLIED = 8;
    public static final int FLAG_GENERIC_VALUE_SUPPLIED = 16;
    private DataOutputStream mDataOutputStream;
    private DataInputStream mDataInputStream;

    public static boolean flag(byte flags, int flag) {
        return (flags & flag) == flag;
    }

    public WritableBuf(byte[] bytes) {
        this(Unpooled.wrappedBuffer((byte[])bytes));
    }

    public WritableBuf(ByteBuf buf) {
        super(buf);
    }

    public DataInputStream getDataInputStream() {
        if (this.mDataInputStream == null) {
            this.mDataInputStream = new DataInputStream((InputStream)new ByteBufInputStream((ByteBuf)this));
        }
        return this.mDataInputStream;
    }

    public DataOutputStream getDataOutputStream() {
        if (this.mDataOutputStream == null) {
            this.mDataOutputStream = new DataOutputStream((OutputStream)new ByteBufOutputStream((ByteBuf)this));
        }
        return this.mDataOutputStream;
    }

    public static <T> Class<T> parseClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T extends IWritable<T>> Class<T> readWritableClass(String className) {
        Class<T> clazz = WritableBuf.parseClass(className);
        if (clazz == null || !IWritable.class.isAssignableFrom(clazz)) {
            new IllegalArgumentException("Class isn't implement IWritable").printStackTrace();
            return null;
        }
        return clazz;
    }

    public <T> Class<T> readClass() {
        return WritableBuf.parseClass(this.readString());
    }

    public WritableBuf writeClass(Class<?> clazz) {
        return this.writeString(clazz.getName());
    }

    public WritableBuf writeString(String s) {
        byte[] bytes = s.getBytes(UTF_8);
        int length = bytes.length;
        this.writeInt(length);
        this.writeBytes(bytes, 0, length);
        return this;
    }

    public String readString() {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new String(bytes, UTF_8);
    }

    public <T extends IWritable<T>> WritableBuf writeWritable(T object) {
        this.writeObjectInfo(object);
        object.write(this);
        return this;
    }

    public WritableBuf writeObjectInfo(Object object) {
        if (object == null) {
            this.writeByte(2);
            return this;
        }
        this.writeByte(0);
        this.writeString(object.getClass().getName());
        return this;
    }

    public <T extends IWritable<T>> T readWritable() {
        byte flags = this.readByte();
        if (WritableBuf.flag(flags, 2)) {
            return null;
        }
        Class<T> objectClass = this.readClass();
        return (T)((IWritable)((Creator.ConstructorBuilder)Creator.creator(objectClass).arg((Object)this)).build());
    }

    public <T extends IWritable<T>> WritableBuf writeArray(T[] objects) {
        if (objects == null) {
            this.writeByte(2);
            return this;
        }
        this.writeByte(20);
        this.writeInt(objects.length);
        this.writeClass(objects.getClass().getComponentType());
        for (T object : objects) {
            this.writeWritable(object);
        }
        return this;
    }

    public <T extends IWritable<T>> T[] readArray() {
        byte flags = this.readByte();
        if (WritableBuf.flag(flags, 2)) {
            return null;
        }
        if (!WritableBuf.flag(flags, 20)) {
            throw new RuntimeException("Array require to known generic type and length");
        }
        int length = this.readInt();
        IWritable[] array = (IWritable[])Array.newInstance(this.readClass(), length);
        for (int i = 0; i < length; ++i) {
            array[i] = this.readWritable();
        }
        return array;
    }

    public <T extends IWritable<T>> WritableBuf writeCollection(Collection<T> collection) {
        return this.writeCollection(collection, null);
    }

    public <T extends IWritable<T>> WritableBuf writeCollection(Collection<T> collection, Class<T> objectType) {
        if (collection == null) {
            this.writeByte(2);
            return this;
        }
        boolean hasGenType = objectType != null;
        this.writeByte(4 | (hasGenType ? 16 : 0));
        this.writeInt(collection.size());
        if (hasGenType) {
            this.writeClass(objectType);
        }
        for (IWritable object : collection) {
            this.writeWritable(object);
        }
        return this;
    }

    public <T extends IWritable<T>> List<T> readCollection() {
        byte flags = this.readByte();
        if (WritableBuf.flag(flags, 2)) {
            return null;
        }
        int length = WritableBuf.flag(flags, 4) ? this.readInt() : -1;
        String genType = WritableBuf.flag(flags, 16) ? this.readString() : null;
        AbstractList collection = length > 0 ? new ArrayList(length) : new LinkedList();
        for (int i = 0; i < length; ++i) {
            collection.add(this.readWritable());
        }
        return collection;
    }

    public <T extends IWritable<T>, C extends Collection<T>> C readCollection(C collection) {
        byte flags = this.readByte();
        if (WritableBuf.flag(flags, 2)) {
            return null;
        }
        int length = WritableBuf.flag(flags, 4) ? this.readInt() : -1;
        String genType = WritableBuf.flag(flags, 16) ? this.readString() : null;
        for (int i = 0; i < length; ++i) {
            collection.add(this.readWritable());
        }
        return collection;
    }

    public <K extends IWritable<K>, V extends IWritable<V>> WritableBuf writeMap(Map<K, V> map) {
        if (map == null) {
            this.writeByte(2);
            return this;
        }
        this.writeByte(4);
        this.writeInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.writeWritable((IWritable)entry.getKey());
            this.writeWritable((IWritable)entry.getValue());
        }
        return this;
    }

    public <K extends IWritable<K>, V extends IWritable<V>> HashMap<K, V> readMap() {
        byte flags = this.readByte();
        if (WritableBuf.flag(flags, 2)) {
            return null;
        }
        if (!WritableBuf.flag(flags, 4)) {
            throw new RuntimeException("Map require to specify size");
        }
        int length = this.readInt();
        HashMap map = new HashMap(length);
        for (int i = 0; i < length; ++i) {
            map.put(this.readWritable(), this.readWritable());
        }
        return map;
    }

    public <K extends IWritable<K>, V extends IWritable<V>, M extends Map<K, V>> M readMap(M map) {
        byte flags = this.readByte();
        if (WritableBuf.flag(flags, 2)) {
            return null;
        }
        if (!WritableBuf.flag(flags, 4)) {
            throw new RuntimeException("Map require to specify size");
        }
        int length = this.readInt();
        for (int i = 0; i < length; ++i) {
            map.put(this.readWritable(), this.readWritable());
        }
        return map;
    }

    public <E extends Enum<E>> WritableBuf writeEnum(E enumObject) {
        if (enumObject == null) {
            this.writeByte(2);
            return this;
        }
        this.writeByte(0);
        this.writeString(enumObject.getDeclaringClass().getName());
        this.writeInt(enumObject.ordinal());
        return this;
    }

    public <E extends Enum<E>> E readEnum() {
        byte flags = this.readByte();
        if (WritableBuf.flag(flags, 2)) {
            return null;
        }
        Class enumClass = this.readClass();
        if (enumClass == null) {
            throw new IllegalArgumentException("Enum class not found");
        }
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        int index = this.readInt();
        if (index >= 0 && index < values.length) {
            return (E)values[index];
        }
        throw new IndexOutOfBoundsException("Illegal index: " + index + ". Size: " + values.length);
    }

    public <K extends Enum<K>, V extends IWritable<V>> WritableBuf writeEnumMap(Map<K, V> map) {
        if (map == null) {
            this.writeByte(2);
            return this;
        }
        this.writeByte(4);
        this.writeInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.writeEnum((Enum)entry.getKey());
            this.writeWritable((IWritable)entry.getValue());
        }
        return this;
    }

    public <K extends Enum<K>, V extends IWritable<V>> EnumMap<K, V> readEnumMap(Class<K> keyClass) {
        EnumMap map = new EnumMap(keyClass);
        this.readEnumMap(map);
        return map;
    }

    public <K extends Enum<K>, V extends IWritable<V>, M extends Map<K, V>> M readEnumMap(M map) {
        byte flags = this.readByte();
        if (WritableBuf.flag(flags, 2)) {
            return null;
        }
        if (!WritableBuf.flag(flags, 4)) {
            throw new RuntimeException("Map require to specify size");
        }
        int length = this.readInt();
        for (int i = 0; i < length; ++i) {
            map.put(this.readEnum(), this.readWritable());
        }
        return map;
    }

    public void writeNBT(NBTBase nbt) {
        if (nbt == null) {
            this.writeByte(-1);
            return;
        }
        this.writeInt(nbt.func_74732_a());
        try {
            nbt.func_74734_a((DataOutput)this.getDataOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends NBTBase> T readNBT() {
        byte type = this.readByte();
        if (type == -1) {
            return null;
        }
        NBTBase nbt = NBTBase.func_150284_a((byte)type);
        try {
            nbt.func_152446_a((DataInput)this.getDataInputStream(), 0, NBTSizeTracker.field_152451_a);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (T)nbt;
    }
}

