/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.ImmutableLHash;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.ParallelKVCharLHash;

public abstract class ImmutableParallelKVCharLHashSO
extends ImmutableLHash
implements ParallelKVCharLHash,
PrimitiveConstants,
UnsafeConstants {
    char freeValue;
    int[] table;

    void copy(ParallelKVCharLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = (int[])hash.table().clone();
    }

    void move(ParallelKVCharLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = hash.table();
    }

    final void init(HashConfigWrapper configWrapper, int size, char freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public char freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public char removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains(((Character)key).charValue());
    }

    public boolean contains(char key) {
        return this.index(key) >= 0;
    }

    int index(char key) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }
}

