/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractObjValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonByteObjMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalByteObjMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableQHashSeparateKVByteObjMapSO;
import com.koloboke.collect.impl.hash.SeparateKVByteObjQHash;
import com.koloboke.collect.map.ByteObjCursor;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteFunction;
import com.koloboke.function.ByteObjConsumer;
import com.koloboke.function.ByteObjFunction;
import com.koloboke.function.ByteObjPredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableQHashSeparateKVByteObjMapGO<V>
extends ImmutableQHashSeparateKVByteObjMapSO<V> {
    @Override
    final void copy(SeparateKVByteObjQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVByteObjQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public Equivalence<V> valueEquivalence() {
        return Equivalence.defaultEquality();
    }

    public boolean containsEntry(byte key, Object value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.nullableValueEquals(this.values[index], value);
        }
        return false;
    }

    public V get(Object key) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V get(byte key) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V getOrDefault(Object key, V defaultValue) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public V getOrDefault(byte key, V defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Byte, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public void forEach(ByteObjConsumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(ByteObjPredicate<? super V> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        byte free = this.freeValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ByteObjCursor<V> cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteObjMapOps.containsAllEntries((InternalByteObjMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalByteObjMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        byte free = this.freeValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalByteObjMapOps<? super V> m) {
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Byte, V>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ObjCollection<V> values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        byte free = this.freeValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            hashCode += key ^ this.nullableValueHashCode(vals[i]);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        byte free = this.freeValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            Object val = vals[i];
            sb.append(val != this ? val : "(this Map)");
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public V put(Byte key, V value) {
        throw new UnsupportedOperationException();
    }

    public V put(byte key, V value) {
        throw new UnsupportedOperationException();
    }

    public V putIfAbsent(Byte key, V value) {
        throw new UnsupportedOperationException();
    }

    public V putIfAbsent(byte key, V value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(byte key, V value) {
        throw new UnsupportedOperationException();
    }

    public V compute(Byte key, BiFunction<? super Byte, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V compute(byte key, ByteObjFunction<? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V computeIfAbsent(Byte key, Function<? super Byte, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V computeIfAbsent(byte key, ByteFunction<? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V computeIfPresent(Byte key, BiFunction<? super Byte, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V computeIfPresent(byte key, ByteObjFunction<? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V merge(Byte key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V merge(byte key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Byte, ? extends V> m) {
        CommonByteObjMapOps.putAll((InternalByteObjMapOps)this, m);
    }

    public V replace(Byte key, V value) {
        throw new UnsupportedOperationException();
    }

    public V replace(byte key, V value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Byte key, V oldValue, V newValue) {
        return this.replace((byte)key, oldValue, newValue);
    }

    public boolean replace(byte key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Byte, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ByteObjFunction<? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(byte key) {
        throw new UnsupportedOperationException();
    }

    public V remove(byte key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, value);
    }

    public boolean remove(byte key, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ByteObjPredicate<? super V> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ByteObjCursor<V> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        int index;
        byte curKey;
        V curValue;

        NoRemovedMapCursor() {
            byte free;
            this.keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue);
        }

        public void forEachForward(ByteObjConsumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ObjCursor<V> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        int index;
        byte curKey;
        V curValue;

        NoRemovedValueCursor() {
            byte free;
            this.keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public V elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ObjIterator<V> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        int nextIndex;
        V next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                byte[] keys = this.keys;
                byte free = this.free;
                Object prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, V>> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        int index;
        byte curKey;
        V curValue;

        NoRemovedEntryCursor() {
            byte free;
            this.keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, V> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, V>> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, V> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                byte[] keys = this.keys;
                byte free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    byte key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractObjValueView<V> {
        ValueView() {
        }

        public Equivalence<V> equivalence() {
            return ImmutableQHashSeparateKVByteObjMapGO.this.valueEquivalence();
        }

        public int size() {
            return ImmutableQHashSeparateKVByteObjMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVByteObjMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVByteObjMapGO.this.containsValue(o);
        }

        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(Predicate<? super V> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ObjCollection<? super V> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.remove(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public ObjIterator<V> iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ObjCursor<V> cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object val;
                if (keys[i] == free) continue;
                sb.append(' ').append((val = vals[i]) != this ? val : "(this Collection)").append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return ImmutableQHashSeparateKVByteObjMapGO.this.removeValue(o);
        }

        public void clear() {
            ImmutableQHashSeparateKVByteObjMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super V> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ByteObjEntry {
        private byte key;
        private V value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ByteObjEntry {
        private final byte key;
        private final V value;

        ImmutableEntry(byte key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    abstract class ByteObjEntry
    extends AbstractEntry<Byte, V> {
        ByteObjEntry() {
        }

        abstract byte key();

        public final Byte getKey() {
            return this.key();
        }

        abstract V value();

        public final V getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                Object v2 = e2.getValue();
                return this.key() == k2 && ImmutableQHashSeparateKVByteObjMapGO.this.nullableValueEquals(v2, this.value());
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((byte)this.key()) ^ ImmutableQHashSeparateKVByteObjMapGO.this.nullableValueHashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, V>>
    implements HashObjSet<Map.Entry<Byte, V>>,
    InternalObjCollectionOps<Map.Entry<Byte, V>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, V>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), ImmutableQHashSeparateKVByteObjMapGO.this.valueEquivalence());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVByteObjMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashSeparateKVByteObjMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVByteObjMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVByteObjMapGO.this.containsEntry((Byte)e.getKey(), e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, V>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || predicate.test((Map.Entry)((Object)new ImmutableEntry(key, vals[i])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Byte, V>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, V>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashSeparateKVByteObjMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = ImmutableQHashSeparateKVByteObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                Object val = vals[i];
                sb.append(val != this ? val : "(this Collection)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVByteObjMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                Object value = e.getValue();
                return ImmutableQHashSeparateKVByteObjMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, V>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

