/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.ByteCursor;
import com.koloboke.collect.ByteIterator;
import com.koloboke.collect.CharCollection;
import com.koloboke.collect.CharCursor;
import com.koloboke.collect.CharIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractCharValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonByteCharMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalByteCharMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashSeparateKVByteCharMapSO;
import com.koloboke.collect.impl.hash.MutableSeparateKVByteLHashGO;
import com.koloboke.collect.impl.hash.SeparateKVByteCharLHash;
import com.koloboke.collect.map.ByteCharCursor;
import com.koloboke.collect.set.CharSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashByteSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteCharConsumer;
import com.koloboke.function.ByteCharPredicate;
import com.koloboke.function.ByteCharToCharFunction;
import com.koloboke.function.BytePredicate;
import com.koloboke.function.ByteToCharFunction;
import com.koloboke.function.CharBinaryOperator;
import com.koloboke.function.CharConsumer;
import com.koloboke.function.CharPredicate;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableLHashSeparateKVByteCharMapGO
extends MutableLHashSeparateKVByteCharMapSO {
    @Override
    final void copy(SeparateKVByteCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVByteCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    public boolean containsEntry(byte key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Character get(Object key) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return null;
    }

    public char get(byte key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Character getOrDefault(Object key, Character defaultValue) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return defaultValue;
    }

    public char getOrDefault(byte key, char defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Byte, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept((Byte)key, Character.valueOf(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ByteCharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ByteCharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ByteCharCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteCharMapOps.containsAllEntries((InternalByteCharMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalByteCharMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalByteCharMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Byte, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            hashCode += key ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        byte[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        char[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            int index = LHash.SeparateKVByteKeyMixing.mix((byte)key) & capacityMask;
            if (newKeys[index] != free) {
                while (newKeys[index = index - 1 & capacityMask] != free) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Character put(Byte key, Character value) {
        int index = this.insert(key, value.charValue());
        if (index < 0) {
            return null;
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value.charValue();
        return Character.valueOf(prevValue);
    }

    public char put(byte key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public Character putIfAbsent(Byte key, Character value) {
        int index = this.insert(key, value.charValue());
        if (index < 0) {
            return null;
        }
        return Character.valueOf(this.values[index]);
    }

    public char putIfAbsent(byte key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    public void justPut(byte key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    public Character compute(Byte key, BiFunction<? super Byte, ? super Character, ? extends Character> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVByteKeyMixing.mix((byte)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply((Byte)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue.charValue();
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)k, Character.valueOf(vals[index]))) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public char compute(byte key, ByteCharToCharFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVByteKeyMixing.mix((byte)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsChar(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(key, vals[index]);
        return newValue;
    }

    public Character computeIfAbsent(Byte key, Function<? super Byte, ? extends Character> mappingFunction) {
        Character value;
        byte k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        byte[] keys = this.set;
        char[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVByteKeyMixing.mix((byte)k) & capacityMask;
        byte cur = keys[index];
        if (cur == k) {
            return Character.valueOf(vals[index]);
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return Character.valueOf(vals[index]);
            } while (cur != free);
        }
        if ((value = mappingFunction.apply((Byte)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value.charValue();
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public char computeIfAbsent(byte key, ByteToCharFunction mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        byte[] keys = this.set;
        char[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVByteKeyMixing.mix((byte)key) & capacityMask;
        byte cur = keys[index];
        if (cur == key) {
            return vals[index];
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return vals[index];
            } while (cur != free);
        }
        char value = mappingFunction.applyAsChar(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    public Character computeIfPresent(Byte key, BiFunction<? super Byte, ? super Character, ? extends Character> remappingFunction) {
        byte k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            char[] vals = this.values;
            Character newValue = remappingFunction.apply((Byte)k, Character.valueOf(vals[index]));
            if (newValue != null) {
                vals[index] = newValue.charValue();
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public char computeIfPresent(byte key, ByteCharToCharFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            char newValue;
            char[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsChar(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Character merge(Byte key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        block5: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVByteKeyMixing.mix((byte)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value.charValue();
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(vals[index]), value)) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public char merge(byte key, char value, CharBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVByteKeyMixing.mix((byte)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(vals[index], value);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public char addValue(byte key, char value) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVByteKeyMixing.mix((byte)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = (char)(this.defaultValue() + value);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (char)(vals[index] + value);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public char addValue(byte key, char addition, char initialValue) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVByteKeyMixing.mix((byte)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = (char)(initialValue + addition);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (char)(vals[index] + addition);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Byte, ? extends Character> m) {
        CommonByteCharMapOps.putAll((InternalByteCharMapOps)this, m);
    }

    public Character replace(Byte key, Character value) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value.charValue();
            return Character.valueOf(oldValue);
        }
        return null;
    }

    public char replace(byte key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Byte key, Character oldValue, Character newValue) {
        return this.replace((byte)key, oldValue.charValue(), newValue.charValue());
    }

    public boolean replace(byte key, char oldValue, char newValue) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Byte, ? super Character, ? extends Character> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            vals[i] = function.apply((Byte)key, Character.valueOf(vals[i])).charValue();
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ByteCharToCharFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            vals[i] = function.applyAsChar(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        byte keyToShift;
        int indexToRemove;
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        int capacityMask = keys.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
            if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = free;
        this.postRemoveHook();
    }

    public Character remove(Object key) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue)) {
            byte keyToShift;
            int indexToRemove;
            byte[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVByteKeyMixing.mix((byte)k) & capacityMask;
            byte cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            char[] vals = this.values;
            char val = vals[index];
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return Character.valueOf(val);
        }
        return null;
    }

    @Override
    public boolean justRemove(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            byte keyToShift;
            int indexToRemove;
            byte[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVByteKeyMixing.mix((byte)key) & capacityMask;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            char[] vals = this.values;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public char remove(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            byte keyToShift;
            int indexToRemove;
            byte[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVByteKeyMixing.mix((byte)key) & capacityMask;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            char[] vals = this.values;
            char val = vals[index];
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, ((Character)value).charValue());
    }

    public boolean remove(byte key, char value) {
        byte free = this.freeValue;
        if (key != free) {
            char[] vals;
            byte[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVByteKeyMixing.mix((byte)key) & capacityMask;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((vals = this.values)[index] == value) {
                byte keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(ByteCharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                byte key = keys[i];
                if (key == free || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Byte> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                byte key = keys[i];
                if (key == free || !filter.test((Byte)key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(BytePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                byte key = keys[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                byte key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                byte key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof ByteCollection) {
            return this.retainAll(thisC, (ByteCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                byte key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                byte key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved, byte delayedRemoved) {
        byte free = this.freeValue;
        byte[] keys = this.set;
        char[] vals = this.values;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            byte keyToShift;
            int indexToRemove;
            if (keys[i] != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if (keyToShift != delayedRemoved && (LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
        }
    }

    @Override
    public ByteIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public ByteCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements ByteCharCursor {
        byte[] keys;
        char[] vals;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index;
        byte curKey;
        char curValue;

        NoRemovedMapCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVByteCharMapGO.this.freeValue);
        }

        public void forEachForward(ByteCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(char value) {
            if (this.curKey == this.free) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashSeparateKVByteCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.vals[this.index] = value;
            if (this.vals == MutableLHashSeparateKVByteCharMapGO.this.values) return;
            MutableLHashSeparateKVByteCharMapGO.this.values[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            byte curKey = this.curKey;
            byte free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteCharMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteCharMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        byte[] keys;
        char[] vals;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index;
        byte curKey;
        char curValue;

        NoRemovedValueCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVByteCharMapGO.this.freeValue);
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            byte curKey = this.curKey;
            byte free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteCharMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteCharMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        byte[] keys;
        char[] vals;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            byte free = this.free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            if (this.expectedModCount == MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteCharMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = vals[indexToShift];
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteCharMapGO.this.justRemove(keys[index]);
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Character>> {
        byte[] keys;
        char[] vals;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index;
        byte curKey;
        char curValue;

        NoRemovedEntryCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVByteCharMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Character>)((Object)new MutableEntry2(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Character> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            byte curKey = this.curKey;
            byte free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteCharMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteCharMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, byte key, char value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(char newValue) {
                if (NoRemovedEntryCursor.this.vals == MutableLHashSeparateKVByteCharMapGO.this.values) {
                    NoRemovedEntryCursor.this.vals[NoRemovedEntryCursor.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVByteCharMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Character>> {
        byte[] keys;
        char[] vals;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            byte free = this.free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry2(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Character>)((Object)new MutableEntry2(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Character> next() {
            int mc = this.expectedModCount;
            if (mc == MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        byte key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry2(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteCharMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashSeparateKVByteCharMapGO.this.modCount(), indexToShift, keyToShift, vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteCharMapGO.this.justRemove(keys[index]);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, byte key, char value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(char newValue) {
                if (NoRemovedEntryIterator.this.vals == MutableLHashSeparateKVByteCharMapGO.this.values) {
                    NoRemovedEntryIterator.this.vals[NoRemovedEntryIterator.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVByteCharMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        public int size() {
            return MutableLHashSeparateKVByteCharMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVByteCharMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableLHashSeparateKVByteCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return MutableLHashSeparateKVByteCharMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeChar(vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public CharCursor cursor() {
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Character.valueOf(vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Character.valueOf(vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return MutableLHashSeparateKVByteCharMapGO.this.removeValue(v);
        }

        public void clear() {
            MutableLHashSeparateKVByteCharMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Character> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    byte key = keys[i];
                    if (key == free || !filter.test(Character.valueOf(vals[i]))) continue;
                    MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(CharPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    byte key = keys[i];
                    if (key == free || !filter.test(vals[i])) continue;
                    MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.removeAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    byte key = keys[i];
                    if (key == free || !c.contains(Character.valueOf(vals[i]))) continue;
                    MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    byte key = keys[i];
                    if (key == free || !c.contains(vals[i])) continue;
                    MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.retainAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    byte key = keys[i];
                    if (key == free || c.contains(Character.valueOf(vals[i]))) continue;
                    MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    byte key = keys[i];
                    if (key == free || c.contains(vals[i])) continue;
                    MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ByteCharEntry {
        private byte key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ByteCharEntry {
        final int modCount;
        private final int index;
        final byte key;
        private char value;

        MutableEntry(int modCount, int index, byte key, char value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }

        public Character setValue(Character newValue) {
            char unwrappedNewValue;
            if (this.modCount != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            char oldValue = this.value;
            this.value = unwrappedNewValue = newValue.charValue();
            this.updateValueInTable(unwrappedNewValue);
            return Character.valueOf(oldValue);
        }

        void updateValueInTable(char newValue) {
            MutableLHashSeparateKVByteCharMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ByteCharEntry
    extends AbstractEntry<Byte, Character> {
        ByteCharEntry() {
        }

        abstract byte key();

        public final Byte getKey() {
            return this.key();
        }

        abstract char value();

        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                char v2 = ((Character)e2.getValue()).charValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((byte)this.key()) ^ Primitives.hashCode((char)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Character>>
    implements HashObjSet<Map.Entry<Byte, Character>>,
    InternalObjCollectionOps<Map.Entry<Byte, Character>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, Character>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashSeparateKVByteCharMapGO.this.hashConfig();
        }

        public int size() {
            return MutableLHashSeparateKVByteCharMapGO.this.size;
        }

        public double currentLoad() {
            return MutableLHashSeparateKVByteCharMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashSeparateKVByteCharMapGO.this.containsEntry((Byte)e.getKey(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Character>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || predicate.test((Map.Entry<Byte, Character>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Byte, Character>> iterator() {
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Character>> cursor() {
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableLHashSeparateKVByteCharMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVByteCharMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                char value = ((Character)e.getValue()).charValue();
                return MutableLHashSeparateKVByteCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Character>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    byte key = keys[i];
                    if (key == free || !filter.test((Map.Entry<Byte, Character>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    byte key = keys[i];
                    if (key == free || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVByteCharMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteCharMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            char[] vals = MutableLHashSeparateKVByteCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    byte key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableLHashSeparateKVByteCharMapGO.this.doClear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVByteLHashGO.NoRemovedCursor {
        char[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashSeparateKVByteCharMapGO.this, mc);
            this.vals = MutableLHashSeparateKVByteCharMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            byte curKey = this.curKey;
            byte free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteCharMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteCharMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVByteLHashGO.NoRemovedIterator {
        char[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashSeparateKVByteCharMapGO.this, mc);
            this.vals = MutableLHashSeparateKVByteCharMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            byte[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteCharMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                MutableLHashSeparateKVByteCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteCharMapGO.this.justRemove(keys[index]);
            }
        }
    }
}

