/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.InternalByteLongMapOps;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashSeparateKVByteKeyMap;
import com.koloboke.collect.impl.hash.SeparateKVByteLongLHash;
import com.koloboke.collect.map.hash.HashByteLongMap;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;

public abstract class MutableLHashSeparateKVByteLongMapSO
extends MutableLHashSeparateKVByteKeyMap
implements HashByteLongMap,
InternalByteLongMapOps,
SeparateKVByteLongLHash {
    long[] values;

    void copy(SeparateKVByteLongLHash hash) {
        super.copy(hash);
        this.values = (long[])hash.valueArray().clone();
    }

    void move(SeparateKVByteLongLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public long[] valueArray() {
        return this.values;
    }

    int valueIndex(long value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(long value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(long value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.containsValue((Long)value);
    }

    int insert(byte key, long value) {
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVByteKeyMixing.mix((byte)key) & capacityMask;
        byte cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return index;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != free) {
                if (cur != key) continue;
                return index;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new long[capacity];
    }
}

