/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ShortCollection;
import com.koloboke.collect.ShortCursor;
import com.koloboke.collect.impl.CommonSetOps;
import com.koloboke.collect.impl.CommonShortCollectionOps;
import com.koloboke.collect.impl.InternalShortCollectionOps;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableShortLHashSetSO;
import com.koloboke.collect.impl.hash.SeparateKVShortLHash;
import com.koloboke.collect.set.ShortSet;
import com.koloboke.collect.set.hash.HashShortSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Set;
import javax.annotation.Nonnull;

public class MutableLHashShortSetGO
extends MutableShortLHashSetSO
implements HashShortSet,
InternalShortCollectionOps {
    @Override
    final void copy(SeparateKVShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals((Set)((Object)this), (Object)obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonShortCollectionOps.containsAll((ShortCollection)this, c);
    }

    @Nonnull
    public ShortCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Short e) {
        return this.add((short)e);
    }

    public boolean add(short key) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        short[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVShortKeyMixing.mix((short)key) & capacityMask;
        short cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != free) {
                if (cur != key) continue;
                return false;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Short> c) {
        return CommonShortCollectionOps.addAll((ShortCollection)this, c);
    }

    public boolean remove(Object key) {
        return this.removeShort((Short)key);
    }

    @Override
    boolean justRemove(short key) {
        return this.removeShort(key);
    }

    public boolean removeShort(short key) {
        short free = this.freeValue;
        if (key != free) {
            short keyToShift;
            int indexToRemove;
            short[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVShortKeyMixing.mix((short)key) & capacityMask;
            short cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVShortKeyMixing.mix((short)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        if (c instanceof ShortCollection) {
            InternalShortCollectionOps c2;
            if (c instanceof InternalShortCollectionOps && (c2 = (InternalShortCollectionOps)c).size() < this.size()) {
                return c2.reverseRemoveAllFrom((ShortSet)this);
            }
            return this.removeAll((HashShortSet)this, (ShortCollection)c);
        }
        return this.removeAll((HashShortSet)this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

