/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.hash.ByteQHashFactory;
import com.koloboke.collect.impl.hash.ImmutableQHashByteSet;
import com.koloboke.collect.impl.hash.ImmutableQHashByteSetGO;
import com.koloboke.collect.impl.hash.MutableQHashByteSet;
import com.koloboke.collect.impl.hash.MutableQHashByteSetGO;
import com.koloboke.collect.impl.hash.SeparateKVByteQHash;
import com.koloboke.collect.impl.hash.UpdatableQHashByteSet;
import com.koloboke.collect.impl.hash.UpdatableQHashByteSetGO;
import com.koloboke.collect.set.hash.HashByteSetFactory;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class QHashByteSetFactorySO
extends ByteQHashFactory<MutableQHashByteSetGO>
implements HashByteSetFactory {
    QHashByteSetFactorySO(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    MutableQHashByteSetGO createNewMutable(int expectedSize, byte free, byte removed) {
        MutableQHashByteSet set = new MutableQHashByteSet();
        set.init(this.configWrapper, expectedSize, free, removed);
        return set;
    }

    MutableQHashByteSetGO uninitializedMutableSet() {
        return new MutableQHashByteSet();
    }

    UpdatableQHashByteSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashByteSet();
    }

    ImmutableQHashByteSetGO uninitializedImmutableSet() {
        return new ImmutableQHashByteSet();
    }

    @Nonnull
    public MutableQHashByteSetGO newMutableSet(int expectedSize) {
        return (MutableQHashByteSetGO)this.newMutableHash(expectedSize);
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashByteSet set = new UpdatableQHashByteSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elements, int expectedSize) {
        if (elements instanceof ByteCollection) {
            SeparateKVByteQHash hash;
            if (elements instanceof SeparateKVByteQHash && (hash = (SeparateKVByteQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashByteSet set = new UpdatableQHashByteSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashByteSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashByteSetGO set = this.newUpdatableSet(size);
        for (byte e : elements) {
            set.add(e);
        }
        return set;
    }
}

