/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.LongCollection;
import com.koloboke.collect.LongCursor;
import com.koloboke.collect.LongIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractLongValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonDoubleLongMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalDoubleLongMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.ParallelKVDoubleLongLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashParallelKVDoubleLongMapSO;
import com.koloboke.collect.map.DoubleLongCursor;
import com.koloboke.collect.set.LongSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.DoubleLongConsumer;
import com.koloboke.function.DoubleLongPredicate;
import com.koloboke.function.DoubleLongToLongFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleToLongFunction;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class UpdatableLHashParallelKVDoubleLongMapGO
extends UpdatableLHashParallelKVDoubleLongMapSO {
    final void copy(ParallelKVDoubleLongLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVDoubleLongLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public long defaultValue() {
        return 0L;
    }

    public boolean containsEntry(double key, long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    public boolean containsEntry(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    public Long get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return null;
    }

    public long get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return this.defaultValue();
    }

    public Long getOrDefault(Object key, Long defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return defaultValue;
    }

    public long getOrDefault(double key, long defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Double, ? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Double)Double.longBitsToDouble(key), (Long)tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(DoubleLongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(DoubleLongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), tab[i + 1])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public DoubleLongCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleLongMapOps.containsAllEntries((InternalDoubleLongMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalDoubleLongMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, tab[i + 1])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalDoubleLongMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Double, Long>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public LongCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            long val = tab[i + 1];
            hashCode += (int)(key ^ key >>> 32) ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(tab[i + 1]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacityMask = newTab.length - 2;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            int index = LHash.ParallelKVDoubleKeyMixing.mix((long)key) & capacityMask;
            if (newTab[index] != 0x7FFFFFFFFFFFFFFEL) {
                while (newTab[index = index - 2 & capacityMask] != 0x7FFFFFFFFFFFFFFEL) {
                }
            }
            newTab[index] = key;
            newTab[index + 1] = tab[i + 1];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Long put(Double key, Long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        long[] tab = this.table;
        long prevValue = tab[index + 1];
        tab[index + 1] = value;
        return prevValue;
    }

    public long put(double key, long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        long[] tab = this.table;
        long prevValue = tab[index + 1];
        tab[index + 1] = value;
        return prevValue;
    }

    public Long putIfAbsent(Double key, Long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        return this.table[index + 1];
    }

    public long putIfAbsent(double key, long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.table[index + 1];
    }

    public void justPut(double key, long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    public void justPut(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    /*
     * Unable to fully structure code
     */
    public Long compute(Double key, BiFunction<? super Double, ? super Long, ? extends Long> remappingFunction) {
        block4: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl12
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl12:
                // 2 sources

                if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), null)) != null) {
                    this.incrementModCount();
                    tab[index] = k;
                    tab[index + 1] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Long)tab[index + 1])) != null) {
            tab[index + 1] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public long compute(double key, DoubleLongToLongFunction remappingFunction) {
        block2: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl12
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl12:
                // 2 sources

                newValue = remappingFunction.applyAsLong(Double.longBitsToDouble(k), this.defaultValue());
                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        tab[index + 1] = newValue = remappingFunction.applyAsLong(Double.longBitsToDouble(k), tab[index + 1]);
        return newValue;
    }

    public Long computeIfAbsent(Double key, Function<? super Double, ? extends Long> mappingFunction) {
        Long value;
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix((long)k) & capacityMask;
        long cur = tab[index];
        if (cur == k) {
            return tab[index + 1];
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            do {
                if ((cur = tab[index = index - 2 & capacityMask]) != k) continue;
                return tab[index + 1];
            } while (cur != 0x7FFFFFFFFFFFFFFEL);
        }
        if ((value = mappingFunction.apply((Double)Double.longBitsToDouble(k))) != null) {
            this.incrementModCount();
            tab[index] = k;
            tab[index + 1] = value;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public long computeIfAbsent(double key, DoubleToLongFunction mappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix((long)k) & capacityMask;
        long cur = tab[index];
        if (cur == k) {
            return tab[index + 1];
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            do {
                if ((cur = tab[index = index - 2 & capacityMask]) != k) continue;
                return tab[index + 1];
            } while (cur != 0x7FFFFFFFFFFFFFFEL);
        }
        long value = mappingFunction.applyAsLong(Double.longBitsToDouble(k));
        this.incrementModCount();
        tab[index] = k;
        tab[index + 1] = value;
        this.postInsertHook();
        return value;
    }

    public Long computeIfPresent(Double key, BiFunction<? super Double, ? super Long, ? extends Long> remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            Long newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Long)tab[index + 1]);
            if (newValue != null) {
                tab[index + 1] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public long computeIfPresent(double key, DoubleLongToLongFunction remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long newValue;
            long[] tab = this.table;
            tab[index + 1] = newValue = remappingFunction.applyAsLong(Double.longBitsToDouble(k), tab[index + 1]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Long merge(Double key, Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        block4: {
            k = Double.doubleToLongBits(key);
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl14
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl14:
                // 2 sources

                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Long)tab[index + 1], value)) != null) {
            tab[index + 1] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public long merge(double key, long value, LongBinaryOperator remappingFunction) {
        block2: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl12
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl12:
                // 2 sources

                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = value;
                this.postInsertHook();
                return value;
            }
        }
        tab[index + 1] = newValue = remappingFunction.applyAsLong(tab[index + 1], value);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public long addValue(double key, long value) {
        block1: {
            k = Double.doubleToLongBits(key);
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl10
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl10:
                // 2 sources

                newValue = this.defaultValue() + value;
                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        tab[index + 1] = newValue = tab[index + 1] + value;
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public long addValue(double key, long addition, long initialValue) {
        block1: {
            k = Double.doubleToLongBits(key);
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl10
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl10:
                // 2 sources

                newValue = initialValue + addition;
                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        tab[index + 1] = newValue = tab[index + 1] + addition;
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Double, ? extends Long> m) {
        CommonDoubleLongMapOps.putAll((InternalDoubleLongMapOps)this, m);
    }

    public Long replace(Double key, Long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            long oldValue = tab[index + 1];
            tab[index + 1] = value;
            return oldValue;
        }
        return null;
    }

    public long replace(double key, long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            long oldValue = tab[index + 1];
            tab[index + 1] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Double key, Long oldValue, Long newValue) {
        return this.replace((double)key, (long)oldValue, (long)newValue);
    }

    public boolean replace(double key, long oldValue, long newValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            if (tab[index + 1] == oldValue) {
                tab[index + 1] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Double, ? super Long, ? extends Long> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            tab[i + 1] = function.apply((Double)Double.longBitsToDouble(key), (Long)tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(DoubleLongToLongFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            tab[i + 1] = function.applyAsLong(Double.longBitsToDouble(key), tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Long remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public long remove(double key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, (Long)value);
    }

    public boolean remove(double key, long value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(DoubleLongPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements DoubleLongCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleLongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), tab[i + 1]);
            }
            if (index != this.index || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.tab[this.index + 1] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements LongCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(tab[i + 1]);
            }
            if (index != this.index || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public long elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements LongIterator {
        final long[] tab;
        int expectedModCount;
        int nextIndex;
        long next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = tab[nextI + 1];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            if (this.expectedModCount == UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    long[] tab = this.tab;
                    long prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        if (tab[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = tab[nextI + 1];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Long)tab[i + 1]);
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(tab[i + 1]);
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Long>> {
        final long[] tab;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Long>)((Object)new MutableEntry(mc, i, key, tab[i + 1])));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Long> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Long>> {
        final long[] tab;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Long>)((Object)new MutableEntry(mc, i, key, tab[i + 1])));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Long> next() {
            int mc = this.expectedModCount;
            if (mc == UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    long[] tab = this.tab;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractLongValueView {
        ValueView() {
        }

        public int size() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.containsValue(o);
        }

        public boolean contains(long v) {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Long)tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(LongPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(tab[i + 1])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(LongCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(tab[i + 1])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(LongCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(LongSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeLong(tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public LongIterator iterator() {
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public LongCursor cursor() {
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public long[] toLongArray() {
            int size = this.size();
            long[] result = new long[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public long[] toArray(long[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new long[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0L;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0L;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(tab[i + 1]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeLong((Long)o);
        }

        public boolean removeLong(long v) {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.removeValue(v);
        }

        public void clear() {
            UpdatableLHashParallelKVDoubleLongMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Long> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(LongPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends DoubleLongEntry {
        private long key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends DoubleLongEntry {
        final int modCount;
        private final int index;
        final long key;
        private long value;

        MutableEntry(int modCount, int index, long key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        public Long setValue(Long newValue) {
            long unwrappedNewValue;
            if (this.modCount != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            long oldValue = this.value;
            this.value = unwrappedNewValue = newValue.longValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            UpdatableLHashParallelKVDoubleLongMapGO.this.table[this.index + 1] = newValue;
        }
    }

    abstract class DoubleLongEntry
    extends AbstractEntry<Double, Long> {
        DoubleLongEntry() {
        }

        abstract long key();

        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract long value();

        public final Long getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                long v2 = (Long)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ Primitives.hashCode((long)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Long>>
    implements HashObjSet<Map.Entry<Double, Long>>,
    InternalObjCollectionOps<Map.Entry<Double, Long>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Double, Long>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.hashConfig();
        }

        public int size() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.size;
        }

        public double currentLoad() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashParallelKVDoubleLongMapGO.this.containsEntry((Double)e.getKey(), (long)((Long)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Long>)((Object)new MutableEntry(mc, i, key, tab[i + 1])));
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Long>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test((Map.Entry<Double, Long>)((Object)new MutableEntry(mc, i, key, tab[i + 1])))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Double, Long>> iterator() {
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Long>> cursor() {
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, tab[i + 1]));
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Long>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(tab[i + 1]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                long value = (Long)e.getValue();
                return UpdatableLHashParallelKVDoubleLongMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Long>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            UpdatableLHashParallelKVDoubleLongMapGO.this.doClear();
        }
    }
}

