/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.ShortCollection;
import com.koloboke.collect.ShortCursor;
import com.koloboke.collect.ShortIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.AbstractShortValueView;
import com.koloboke.collect.impl.CommonDoubleShortMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalDoubleShortMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.SeparateKVDoubleShortLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashSeparateKVDoubleShortMapSO;
import com.koloboke.collect.map.DoubleShortCursor;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.ShortSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.DoubleShortConsumer;
import com.koloboke.function.DoubleShortPredicate;
import com.koloboke.function.DoubleShortToShortFunction;
import com.koloboke.function.DoubleToShortFunction;
import com.koloboke.function.ShortBinaryOperator;
import com.koloboke.function.ShortConsumer;
import com.koloboke.function.ShortPredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class UpdatableLHashSeparateKVDoubleShortMapGO
extends UpdatableLHashSeparateKVDoubleShortMapSO {
    @Override
    final void copy(SeparateKVDoubleShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVDoubleShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    public boolean containsEntry(double key, short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public boolean containsEntry(long key, short value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Short get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public short get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Short getOrDefault(Object key, Short defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public short getOrDefault(double key, short defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Double, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Double)Double.longBitsToDouble(key), (Short)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(DoubleShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(DoubleShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public DoubleShortCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleShortMapOps.containsAllEntries((InternalDoubleShortMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalDoubleShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalDoubleShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Double, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        short[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            int index = LHash.SeparateKVDoubleKeyMixing.mix((long)key) & capacityMask;
            if (newKeys[index] != 0x7FFFFFFFFFFFFFFEL) {
                while (newKeys[index = index - 1 & capacityMask] != 0x7FFFFFFFFFFFFFFEL) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Short put(Double key, Short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public short put(double key, short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public Short putIfAbsent(Double key, Short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    public short putIfAbsent(double key, short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    public void justPut(double key, short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    public void justPut(long key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    public Short compute(Double key, BiFunction<? super Double, ? super Short, ? extends Short> remappingFunction) {
        block4: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl13:
                // 2 sources

                if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Short)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public short compute(double key, DoubleShortToShortFunction remappingFunction) {
        block2: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl13:
                // 2 sources

                newValue = remappingFunction.applyAsShort(Double.longBitsToDouble(k), this.defaultValue());
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(Double.longBitsToDouble(k), vals[index]);
        return newValue;
    }

    public Short computeIfAbsent(Double key, Function<? super Double, ? extends Short> mappingFunction) {
        Short value;
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] keys = this.set;
        short[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
        long cur = keys[index];
        if (cur == k) {
            return vals[index];
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return vals[index];
            } while (cur != 0x7FFFFFFFFFFFFFFEL);
        }
        if ((value = mappingFunction.apply((Double)Double.longBitsToDouble(k))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public short computeIfAbsent(double key, DoubleToShortFunction mappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] keys = this.set;
        short[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
        long cur = keys[index];
        if (cur == k) {
            return vals[index];
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return vals[index];
            } while (cur != 0x7FFFFFFFFFFFFFFEL);
        }
        short value = mappingFunction.applyAsShort(Double.longBitsToDouble(k));
        this.incrementModCount();
        keys[index] = k;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    public Short computeIfPresent(Double key, BiFunction<? super Double, ? super Short, ? extends Short> remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            Short newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Short)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public short computeIfPresent(double key, DoubleShortToShortFunction remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            short newValue;
            short[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsShort(Double.longBitsToDouble(k), vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Short merge(Double key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        block4: {
            k = Double.doubleToLongBits(key);
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Short)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public short merge(double key, short value, ShortBinaryOperator remappingFunction) {
        block2: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl13:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(vals[index], value);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public short addValue(double key, short value) {
        block1: {
            k = Double.doubleToLongBits(key);
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl11
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl11:
                // 2 sources

                newValue = (short)(this.defaultValue() + value);
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (short)(vals[index] + value);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public short addValue(double key, short addition, short initialValue) {
        block1: {
            k = Double.doubleToLongBits(key);
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVDoubleKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl11
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl11:
                // 2 sources

                newValue = (short)(initialValue + addition);
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (short)(vals[index] + addition);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Double, ? extends Short> m) {
        CommonDoubleShortMapOps.putAll((InternalDoubleShortMapOps)this, m);
    }

    public Short replace(Double key, Short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    public short replace(double key, short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Double key, Short oldValue, Short newValue) {
        return this.replace((double)key, (short)oldValue, (short)newValue);
    }

    public boolean replace(double key, short oldValue, short newValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Double, ? super Short, ? extends Short> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            vals[i] = function.apply((Double)Double.longBitsToDouble(key), (Short)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(DoubleShortToShortFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            vals[i] = function.applyAsShort(Double.longBitsToDouble(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Short remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public short remove(double key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, (Short)value);
    }

    public boolean remove(double key, short value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(DoubleShortPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements DoubleShortCursor {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), vals[i]);
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public short elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int nextIndex;
        short next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            this.vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            if (this.expectedModCount == UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    long[] keys = this.keys;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Short)vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Short>> {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Short>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Short> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Short>> {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            this.vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Short>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Short> next() {
            int mc = this.expectedModCount;
            if (mc == UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    long[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        public int size() {
            return UpdatableLHashSeparateKVDoubleShortMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashSeparateKVDoubleShortMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return UpdatableLHashSeparateKVDoubleShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return UpdatableLHashSeparateKVDoubleShortMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Short)vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeShort(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ShortCursor cursor() {
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return UpdatableLHashSeparateKVDoubleShortMapGO.this.removeValue(v);
        }

        public void clear() {
            UpdatableLHashSeparateKVDoubleShortMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Short> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(ShortPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends DoubleShortEntry {
        private long key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    class MutableEntry
    extends DoubleShortEntry {
        final int modCount;
        private final int index;
        final long key;
        private short value;

        MutableEntry(int modCount, int index, long key, short value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }

        public Short setValue(Short newValue) {
            short unwrappedNewValue;
            if (this.modCount != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            short oldValue = this.value;
            this.value = unwrappedNewValue = newValue.shortValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(short newValue) {
            UpdatableLHashSeparateKVDoubleShortMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class DoubleShortEntry
    extends AbstractEntry<Double, Short> {
        DoubleShortEntry() {
        }

        abstract long key();

        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract short value();

        public final Short getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ Primitives.hashCode((short)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Short>>
    implements HashObjSet<Map.Entry<Double, Short>>,
    InternalObjCollectionOps<Map.Entry<Double, Short>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Double, Short>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashSeparateKVDoubleShortMapGO.this.hashConfig();
        }

        public int size() {
            return UpdatableLHashSeparateKVDoubleShortMapGO.this.size;
        }

        public double currentLoad() {
            return UpdatableLHashSeparateKVDoubleShortMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashSeparateKVDoubleShortMapGO.this.containsEntry((Double)e.getKey(), (short)((Short)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Short>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test((Map.Entry<Double, Short>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Double, Short>> iterator() {
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Short>> cursor() {
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return UpdatableLHashSeparateKVDoubleShortMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = UpdatableLHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = UpdatableLHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashSeparateKVDoubleShortMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                short value = (Short)e.getValue();
                return UpdatableLHashSeparateKVDoubleShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Short>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            UpdatableLHashSeparateKVDoubleShortMapGO.this.doClear();
        }
    }
}

