/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractObjValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonIntObjMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalIntObjMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.SeparateKVIntObjLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashSeparateKVIntObjMapSO;
import com.koloboke.collect.map.IntObjCursor;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.IntObjConsumer;
import com.koloboke.function.IntObjFunction;
import com.koloboke.function.IntObjPredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class UpdatableLHashSeparateKVIntObjMapGO<V>
extends UpdatableLHashSeparateKVIntObjMapSO<V> {
    @Override
    final void copy(SeparateKVIntObjLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVIntObjLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public Equivalence<V> valueEquivalence() {
        return Equivalence.defaultEquality();
    }

    public boolean containsEntry(int key, Object value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.nullableValueEquals(this.values[index], value);
        }
        return false;
    }

    public V get(Object key) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V get(int key) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V getOrDefault(Object key, V defaultValue) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public V getOrDefault(int key, V defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Integer, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(IntObjConsumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(IntObjPredicate<? super V> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public IntObjCursor<V> cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntObjMapOps.containsAllEntries((InternalIntObjMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalIntObjMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalIntObjMapOps<? super V> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Integer, V>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ObjCollection<V> values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            hashCode += key ^ this.nullableValueHashCode(vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            Object val = vals[i];
            sb.append(val != this ? val : "(this Map)");
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        Object[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            int index = LHash.SeparateKVIntKeyMixing.mix((int)key) & capacityMask;
            if (newKeys[index] != free) {
                while (newKeys[index = index - 1 & capacityMask] != free) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public V put(Integer key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    public V put(int key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    public V putIfAbsent(Integer key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    public V putIfAbsent(int key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    public void justPut(int key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    public V compute(Integer key, BiFunction<? super Integer, ? super V, ? extends V> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVIntKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply(k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(k, vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public V compute(int key, IntObjFunction<? super V, ? extends V> remappingFunction) {
        block5: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVIntKeyMixing.mix((int)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block5;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                if ((newValue = remappingFunction.apply(key, null)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return (V)newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(key, vals[index])) != null) {
            vals[index] = newValue;
            return (V)newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public V computeIfAbsent(Integer key, Function<? super Integer, ? extends V> mappingFunction) {
        block6: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVIntKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block6;
            if (cur == free) ** GOTO lbl16
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((value = mappingFunction.apply(k)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = value;
                    this.postInsertHook();
                    return value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        value = mappingFunction.apply(k);
        if (value != null) {
            vals[index] = value;
            return value;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public V computeIfAbsent(int key, IntFunction<? extends V> mappingFunction) {
        block6: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVIntKeyMixing.mix((int)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block6;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                if ((value = mappingFunction.apply(key)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = value;
                    this.postInsertHook();
                    return value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        value = mappingFunction.apply(key);
        if (value != null) {
            vals[index] = value;
            return value;
        }
        return null;
    }

    public V computeIfPresent(Integer key, BiFunction<? super Integer, ? super V, ? extends V> remappingFunction) {
        int k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                V newValue = remappingFunction.apply(k, val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return newValue;
                }
                throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
            }
            return null;
        }
        return null;
    }

    public V computeIfPresent(int key, IntObjFunction<? super V, ? extends V> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                Object newValue = remappingFunction.apply(key, val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return (V)newValue;
                }
                throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
            }
            return null;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public V merge(Integer key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        block6: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVIntKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block6;
            if (cur == free) ** GOTO lbl18
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
        }
        vals[index] = value;
        return value;
    }

    /*
     * Unable to fully structure code
     */
    public V merge(int key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        block6: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVIntKeyMixing.mix((int)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block6;
            if (cur == free) ** GOTO lbl17
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl17:
                // 2 sources

                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
        }
        vals[index] = value;
        return value;
    }

    public void putAll(@Nonnull Map<? extends Integer, ? extends V> m) {
        CommonIntObjMapOps.putAll((InternalIntObjMapOps)this, m);
    }

    public V replace(Integer key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    public V replace(int key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    public boolean replace(Integer key, V oldValue, V newValue) {
        return this.replace((int)key, oldValue, newValue);
    }

    public boolean replace(int key, V oldValue, V newValue) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            if (this.nullableValueEquals(vals[index], oldValue)) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Integer, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            vals[i] = function.apply(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(IntObjFunction<? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            vals[i] = function.apply(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public V remove(int key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, value);
    }

    public boolean remove(int key, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(IntObjPredicate<? super V> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements IntObjCursor<V> {
        final int[] keys;
        final V[] vals;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        V curValue;

        NoRemovedMapCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            this.curKey = free = (this.free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue);
        }

        public void forEachForward(IntObjConsumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ObjCursor<V> {
        final int[] keys;
        final V[] vals;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        V curValue;

        NoRemovedValueCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            this.curKey = free = (this.free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public V elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ObjIterator<V> {
        final int[] keys;
        final V[] vals;
        final int free;
        int expectedModCount;
        int nextIndex;
        V next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            this.vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            if (this.expectedModCount == UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    int[] keys = this.keys;
                    int free = this.free;
                    Object prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, V>> {
        final int[] keys;
        final V[] vals;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        V curValue;

        NoRemovedEntryCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            this.curKey = free = (this.free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, V> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                int[] keys = this.keys;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, V>> {
        final int[] keys;
        final V[] vals;
        final int free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            this.vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            int free = this.free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            V[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, V> next() {
            int mc = this.expectedModCount;
            if (mc == UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    int[] keys = this.keys;
                    int free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractObjValueView<V> {
        ValueView() {
        }

        public Equivalence<V> equivalence() {
            return UpdatableLHashSeparateKVIntObjMapGO.this.valueEquivalence();
        }

        public int size() {
            return UpdatableLHashSeparateKVIntObjMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashSeparateKVIntObjMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return UpdatableLHashSeparateKVIntObjMapGO.this.containsValue(o);
        }

        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(Predicate<? super V> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ObjCollection<? super V> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.remove(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ObjIterator<V> iterator() {
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ObjCursor<V> cursor() {
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object val;
                if (keys[i] == free) continue;
                sb.append(' ').append((val = vals[i]) != this ? val : "(this Collection)").append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return UpdatableLHashSeparateKVIntObjMapGO.this.removeValue(o);
        }

        public void clear() {
            UpdatableLHashSeparateKVIntObjMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super V> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends IntObjEntry {
        private int key;
        private V value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    class MutableEntry
    extends IntObjEntry {
        final int modCount;
        private final int index;
        final int key;
        private V value;

        MutableEntry(int modCount, int index, int key, V value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        public V setValue(V newValue) {
            if (this.modCount != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            Object oldValue = this.value;
            Object unwrappedNewValue = newValue;
            this.value = unwrappedNewValue;
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(V newValue) {
            UpdatableLHashSeparateKVIntObjMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class IntObjEntry
    extends AbstractEntry<Integer, V> {
        IntObjEntry() {
        }

        abstract int key();

        public final Integer getKey() {
            return this.key();
        }

        abstract V value();

        public final V getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                Object v2 = e2.getValue();
                return this.key() == k2 && UpdatableLHashSeparateKVIntObjMapGO.this.nullableValueEquals(v2, this.value());
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((int)this.key()) ^ UpdatableLHashSeparateKVIntObjMapGO.this.nullableValueHashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, V>>
    implements HashObjSet<Map.Entry<Integer, V>>,
    InternalObjCollectionOps<Map.Entry<Integer, V>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Integer, V>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), UpdatableLHashSeparateKVIntObjMapGO.this.valueEquivalence());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashSeparateKVIntObjMapGO.this.hashConfig();
        }

        public int size() {
            return UpdatableLHashSeparateKVIntObjMapGO.this.size;
        }

        public double currentLoad() {
            return UpdatableLHashSeparateKVIntObjMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashSeparateKVIntObjMapGO.this.containsEntry((Integer)e.getKey(), e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, V>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Integer, V>> iterator() {
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, V>> cursor() {
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return UpdatableLHashSeparateKVIntObjMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashSeparateKVIntObjMapGO.this.modCount();
            int free = UpdatableLHashSeparateKVIntObjMapGO.this.freeValue;
            int[] keys = UpdatableLHashSeparateKVIntObjMapGO.this.set;
            Object[] vals = UpdatableLHashSeparateKVIntObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                Object val = vals[i];
                sb.append(val != this ? val : "(this Collection)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashSeparateKVIntObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashSeparateKVIntObjMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                Object value = e.getValue();
                return UpdatableLHashSeparateKVIntObjMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, V>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            UpdatableLHashSeparateKVIntObjMapGO.this.doClear();
        }
    }
}

