/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.SeparateKVDoubleLHash;
import com.koloboke.collect.impl.hash.UpdatableLHash;
import java.util.Arrays;

public abstract class UpdatableSeparateKVDoubleLHashSO
extends UpdatableLHash
implements SeparateKVDoubleLHash,
PrimitiveConstants,
UnsafeConstants {
    long[] set;

    void copy(SeparateKVDoubleLHash hash) {
        super.copy(hash);
        this.set = (long[])hash.keys().clone();
    }

    void move(SeparateKVDoubleLHash hash) {
        super.copy(hash);
        this.set = hash.keys();
    }

    public boolean contains(Object key) {
        return this.contains((Double)key);
    }

    public boolean contains(double key) {
        return this.index(Double.doubleToLongBits(key)) >= 0;
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix((long)key) & capacityMask;
        long cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur == 0x7FFFFFFFFFFFFFFEL) {
            return -1;
        }
        do {
            if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
            return index;
        } while (cur != 0x7FFFFFFFFFFFFFFEL);
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        this.set = new long[capacity];
        Arrays.fill(this.set, 0x7FFFFFFFFFFFFFFEL);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.set, 0x7FFFFFFFFFFFFFFEL);
    }
}

