/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.HashOverflowException;
import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.ShortArrays;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVShortQHash;
import com.koloboke.collect.impl.hash.UpdatableQHash;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class UpdatableSeparateKVShortQHashSO
extends UpdatableQHash
implements SeparateKVShortQHash,
PrimitiveConstants,
UnsafeConstants {
    short freeValue;
    short[] set;

    void copy(SeparateKVShortQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (short[])hash.keys().clone();
    }

    void move(SeparateKVShortQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, short freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public short freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public short removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Short)key);
    }

    public boolean contains(short key) {
        return this.index(key) >= 0;
    }

    int index(short key) {
        short free = this.freeValue;
        if (key != free) {
            short[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVShortKeyMixing.mix((short)key) % capacity;
            short cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }

    private short findNewFreeOrRemoved() {
        short newFree;
        block6: {
            int mc = this.modCount();
            int size = this.size();
            if (size >= 65535) {
                throw new HashOverflowException();
            }
            short free = this.freeValue;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (size > 49152) {
                int nf = ((Random)random).nextInt(65536) * 21859;
                for (int i = 0; i < 65536; ++i) {
                    newFree = (short)(nf += 21859);
                    if (newFree == free || this.index(newFree) >= 0) {
                        continue;
                    }
                    break block6;
                }
                if (mc != this.modCount()) {
                    throw new ConcurrentModificationException();
                }
                throw new AssertionError((Object)"Impossible state");
            }
            while ((newFree = (short)((Random)random).nextInt()) == free || this.index(newFree) >= 0) {
            }
        }
        return newFree;
    }

    short changeFree() {
        int mc = this.modCount();
        short newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ShortArrays.replaceAll((short[])this.set, (short)this.freeValue, (short)newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.set = new short[capacity];
        if (this.freeValue != 0) {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.set, this.freeValue);
    }
}

