/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.mutabilitydetector.asm.tree.analysis;

import java.util.List;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import shaded.org.mutabilitydetector.asm.typehierarchy.TypeHierarchy;
import shaded.org.mutabilitydetector.asm.typehierarchy.TypeHierarchyReader;

public class NonClassloadingSimpleVerifier
extends SimpleVerifier {
    final LaunchClassLoader loader;
    private final Type currentClass;
    private final Type currentSuperClass;
    private final List<Type> currentClassInterfaces;
    private final boolean isInterface;
    protected final TypeHierarchyReader typeHierarchyReader;

    public NonClassloadingSimpleVerifier(LaunchClassLoader loader) {
        this(new TypeHierarchyReader(loader), loader);
    }

    public NonClassloadingSimpleVerifier(Type currentClass, Type currentSuperClass, boolean isInterface, LaunchClassLoader loader) {
        this(loader, currentClass, currentSuperClass, null, isInterface, new TypeHierarchyReader(loader));
    }

    public NonClassloadingSimpleVerifier(TypeHierarchyReader reader, LaunchClassLoader loader) {
        this(loader, null, null, null, false, reader);
    }

    public NonClassloadingSimpleVerifier(LaunchClassLoader loader, Type currentClass, Type currentSuperClass, List<Type> currentClassInterfaces, boolean isInterface, TypeHierarchyReader reader) {
        this.loader = loader;
        this.currentClass = currentClass;
        this.currentSuperClass = currentSuperClass;
        this.currentClassInterfaces = currentClassInterfaces;
        this.isInterface = isInterface;
        this.typeHierarchyReader = reader;
    }

    protected Class<?> getClass(Type t) {
        throw new Error("Programming error: this verifier should not be attempting to load classes.");
    }

    protected boolean isInterface(Type t) {
        if (this.currentClass != null && t.equals((Object)this.currentClass)) {
            return this.isInterface;
        }
        return this.typeHierarchyReader.isInterface(t);
    }

    protected Type getSuperClass(Type t) {
        if (this.currentClass != null && t.equals((Object)this.currentClass)) {
            return this.currentSuperClass;
        }
        return this.typeHierarchyReader.getSuperClass(t);
    }

    public boolean isAssignableFrom(Type toType, Type fromType) {
        if (toType.equals((Object)fromType)) {
            return true;
        }
        if (this.currentClass != null && toType.equals((Object)this.currentClass)) {
            if (this.getSuperClass(fromType) == null) {
                return false;
            }
            if (this.isInterface) {
                return fromType.getSort() == 10 || fromType.getSort() == 9;
            }
            return this.isAssignableFrom(toType, this.getSuperClass(fromType));
        }
        if (this.currentClass != null && fromType.equals((Object)this.currentClass)) {
            if (this.isAssignableFrom(toType, this.currentSuperClass)) {
                return true;
            }
            if (this.currentClassInterfaces != null) {
                for (int i = 0; i < this.currentClassInterfaces.size(); ++i) {
                    Type v = this.currentClassInterfaces.get(i);
                    if (!this.isAssignableFrom(toType, v)) continue;
                    return true;
                }
            }
            return false;
        }
        TypeHierarchy tc = this.typeHierarchyReader.hierarchyOf(toType);
        if (tc.isInterface()) {
            tc = TypeHierarchy.JAVA_LANG_OBJECT;
        }
        return tc.isAssignableFrom(fromType, this.typeHierarchyReader);
    }
}

