/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.damask.api;

import java.util.LinkedList;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import pw.prok.damask.Damask;
import pw.prok.damask.api.VersionListResult;
import pw.prok.damask.dsl.Builder;
import pw.prok.damask.dsl.IModule;
import pw.prok.damask.dsl.IModuleVersion;
import pw.prok.damask.dsl.IRepository;
import pw.prok.damask.dsl.Version;
import pw.prok.damask.internal.job.DamaskRequest;

public class VersionListRequest
extends DamaskRequest<VersionListResult> {
    public IModule mModule;

    public VersionListRequest(IModule module) {
        this.mModule = module;
    }

    @Override
    public VersionListResult performRequest(Damask damask, IRepository repository) throws Exception {
        Version matching = null;
        if (this.mModule instanceof IModuleVersion) {
            matching = ((IModuleVersion)this.mModule).getVersion();
        }
        LinkedList<IModuleVersion> versions = new LinkedList<IModuleVersion>();
        Document document = this.parse(Builder.asPath(this.mModule, false, false, repository, "maven-metadata.xml"));
        NodeList nodes = (NodeList)Damask.x().evaluate("/metadata/versioning/versions[*]/version", document, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IModuleVersion candidate = Builder.create().fromModule(this.mModule).version(nodes.item(i).getFirstChild().getNodeValue()).asModuleVersion();
            if (matching != null && !matching.isMatching(candidate.getVersion())) continue;
            versions.add(candidate);
        }
        return new VersionListResult(versions);
    }
}

