/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.damask.cache;

import pw.prok.damask.cache.CacheMemory;
import pw.prok.damask.cache.ICache;

public class SimpleCache<T> {
    private final ICache<T> mCache;

    private SimpleCache(ICache<T> cache) {
        this.mCache = cache;
    }

    public static <T> SimpleCache<T> cache(ICache<T> cache) {
        assert (cache != null);
        return new SimpleCache<T>(cache);
    }

    public static <T> SimpleCache<T> memoryCache() {
        return SimpleCache.cache(new CacheMemory(false));
    }

    public static <T> SimpleCache<T> memoryCacheHashed() {
        return SimpleCache.cache(new CacheMemory(true));
    }

    public T get(String key) {
        return this.mCache.get(key);
    }

    public T put(String key, T value) {
        return this.mCache.put(key, value);
    }
}

