/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.damask.dsl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pw.prok.damask.dsl.DefaultArtifact;
import pw.prok.damask.dsl.DefaultModule;
import pw.prok.damask.dsl.DefaultModuleVersion;
import pw.prok.damask.dsl.IArtifact;
import pw.prok.damask.dsl.IModule;
import pw.prok.damask.dsl.IModuleVersion;
import pw.prok.damask.dsl.IRepository;
import pw.prok.damask.dsl.Version;

public class Builder {
    public static final String DEFAULT_EXTENSION = "jar";
    private String mGroup;
    private String mName;
    private Version mVersion;
    private String mClassifier;
    private String mExtension;
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("^((?<group>[^:@]+):)?(?<name>[^:@]+)(:(?<version>[^:@]+)(:(?<classifier>[^:@]+))?)?(?<extension>@.+)?$");
    private static final String ARTIFACT_FORMAT = "[group:]name[:version[:classifier]][@extension]";

    private Builder() {
    }

    public static Builder create() {
        return new Builder();
    }

    public Builder group(String group) {
        this.mGroup = group;
        return this;
    }

    public Builder name(String name) {
        this.mName = name;
        return this;
    }

    public Builder version(Version version) {
        this.mVersion = version;
        return this;
    }

    public Builder version(String version) {
        return this.version(version != null ? new Version(version) : null);
    }

    public Builder classifier(String classifier) {
        this.mClassifier = classifier;
        return this;
    }

    public Builder extension(String extension) {
        this.mExtension = extension;
        return this;
    }

    public Builder fromModule(IModule module) {
        this.mGroup = module.getGroup();
        this.mName = module.getName();
        return this;
    }

    public Builder fromModuleVersion(IModuleVersion moduleVersion) {
        this.fromModule(moduleVersion);
        this.mVersion = moduleVersion.getVersion();
        return this;
    }

    public Builder fromArtifact(IArtifact artifact) {
        this.fromModuleVersion(artifact);
        this.mClassifier = artifact.getClassifier();
        this.mExtension = artifact.getExtension();
        return this;
    }

    public IModule asModule() {
        return this.fillModule(new DefaultModule());
    }

    public IModuleVersion asModuleVersion() {
        return this.fillModuleVersion(new DefaultModuleVersion());
    }

    public IArtifact asArtifact() {
        return this.fillArtifact(new DefaultArtifact());
    }

    public <T extends DefaultModule> T fillModule(T module) {
        module.setGroup(this.mGroup);
        module.setName(this.mName);
        return module;
    }

    public <T extends DefaultModuleVersion> T fillModuleVersion(T moduleVersion) {
        moduleVersion.setVersion(this.mVersion);
        return this.fillModule(moduleVersion);
    }

    public <T extends DefaultArtifact> T fillArtifact(T artifact) {
        artifact.setClassifier(this.mClassifier);
        artifact.setExtension(this.mExtension != null ? this.mExtension : DEFAULT_EXTENSION);
        return this.fillModuleVersion(artifact);
    }

    public boolean enoughModuleVersion() {
        return this.mClassifier == null && this.mExtension == null;
    }

    public boolean enoughModule() {
        return this.enoughModuleVersion() && this.mVersion == null;
    }

    public IModule buildEnough() {
        if (this.enoughModule()) {
            return this.asModule();
        }
        if (this.enoughModuleVersion()) {
            return this.asModuleVersion();
        }
        return this.asArtifact();
    }

    public Builder clear() {
        this.mVersion = null;
        this.mExtension = null;
        this.mClassifier = null;
        this.mName = null;
        this.mGroup = null;
        return this;
    }

    public Builder parse(String s) {
        Matcher matcher = ARTIFACT_PATTERN.matcher(s);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Could not parse " + s + "! Required format: " + ARTIFACT_FORMAT);
        }
        this.group(matcher.group("group"));
        this.name(matcher.group("name"));
        this.version(matcher.group("version"));
        this.classifier(matcher.group("classifier"));
        this.extension(matcher.group("extension"));
        return this;
    }

    public static String asPath(IModule module) {
        return Builder.asPath(module, true, true);
    }

    public static String asPath(IModule module, boolean allowVersion, boolean allowArtifact) {
        return Builder.asPath(module, allowVersion, allowArtifact, null, null);
    }

    public static String asPath(IModule module, boolean allowVersion, boolean allowArtifact, IRepository repository) {
        return Builder.asPath(module, allowVersion, allowArtifact, repository, null);
    }

    public static String asPath(IModule module, boolean allowVersion, boolean allowArtifact, IRepository repository, String filename) {
        StringBuilder builder = new StringBuilder();
        boolean needFirstSlash = false;
        if (repository != null) {
            builder.append(repository.getURL());
            if (builder.charAt(builder.length() - 1) == '/') {
                builder.deleteCharAt(builder.length() - 1);
            }
        }
        for (String s : module.getGroup().split("\\.")) {
            builder.append('/');
            builder.append(s);
        }
        builder.append('/');
        builder.append(module.getName());
        if (allowVersion && module instanceof IModuleVersion) {
            IModuleVersion moduleVersion = (IModuleVersion)module;
            builder.append('/');
            builder.append(moduleVersion.getVersion().toRawString());
            builder.append('/');
            if (allowArtifact && module instanceof IArtifact) {
                builder.append(Builder.toString((IArtifact)module));
            }
        }
        if (filename != null) {
            builder.append('/');
            builder.append(filename);
        }
        return builder.toString();
    }

    public static String toString(IArtifact artifact) {
        StringBuilder builder = new StringBuilder();
        builder.append(artifact.getName());
        builder.append('-');
        builder.append(artifact.getVersion().toSnapshotString());
        String classifier = artifact.getClassifier();
        if (classifier != null && classifier.length() > 0) {
            builder.append('-');
            builder.append(classifier);
        }
        builder.append('.');
        builder.append(artifact.getExtension());
        return builder.toString();
    }
}

