/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.damask.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class Request {
    private String method;
    private String url;
    private String contentType;
    private InputStream content;
    private long contentLength = -1L;
    private Map<String, String[]> headers;
    private byte[] cacheContent;

    public static Request get(String url) {
        Request request = new Request();
        request.method = "GET";
        request.url = url;
        return request;
    }

    public Request clearHeaders() {
        this.headers = null;
        return this;
    }

    public Request addHeader(String name, String value) {
        if (value == null) {
            return this;
        }
        this.accureHeaders();
        String[] s = this.headers.get(name);
        if (s == null || s.length == 0) {
            s = new String[]{value};
        } else {
            String[] ns = new String[s.length + 1];
            System.arraycopy(s, 0, ns, 0, s.length);
            ns[s.length] = value;
            s = ns;
        }
        this.headers.put(name, s);
        return this;
    }

    public Request header(String name, String value) {
        this.accureHeaders();
        if (value == null) {
            this.headers.remove(name);
        } else {
            this.headers.put(name, new String[]{value});
        }
        return this;
    }

    public Request removeHeader(String name) {
        if (this.headers == null) {
            return this;
        }
        return this.header(name, null);
    }

    private void accureHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String[]>();
        }
    }

    public Request headers(Map<String, String[]> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String[]> headers() {
        return this.headers;
    }

    public Request url(String url) {
        this.url = url;
        return this;
    }

    public String url() {
        return this.url;
    }

    public String method() {
        return this.method;
    }

    public Request method(String method) {
        this.method = method;
        return this;
    }

    public Request get() {
        this.method = "GET";
        this.content = null;
        this.contentLength = -1L;
        this.contentType = null;
        return this;
    }

    public Request post(InputStream content, long contentLength, String contentType) {
        this.method = "POST";
        this.content = content;
        this.contentLength = contentLength;
        this.contentType = contentType;
        return this;
    }

    public InputStream content() {
        return this.content;
    }

    public Request content(InputStream content) {
        this.content = content;
        return this;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public Request contentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public Request contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public void cacheContent(byte[] cacheContent) {
        this.cacheContent = cacheContent;
    }

    public void prepare() {
        if (this.cacheContent != null) {
            this.content = new ByteArrayInputStream(this.cacheContent);
            this.contentLength = this.cacheContent.length;
        }
    }
}

