/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.damask.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import pw.prok.damask.http.IResponse;
import pw.prok.damask.http.SimpleHttp;

public class Response
implements IResponse {
    private int status;
    private Map<String, String[]> headers;
    private InputStream content;
    private long contentLength;
    private byte[] contentBytes;
    private static final Charset UTF_8 = Charset.forName("utf-8");

    @Override
    public int status() {
        return this.status;
    }

    public Response status(int status) {
        this.status = status;
        return this;
    }

    @Override
    public Map<String, String[]> headers() {
        return this.headers;
    }

    public Response headers(Map<String, String[]> headers) {
        this.headers = headers;
        return this;
    }

    @Override
    public InputStream content() {
        return this.content;
    }

    public Response content(InputStream content) {
        this.content = content;
        return this;
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    public Response contentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    @Override
    public String[] headers(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    @Override
    public String header(String name) {
        String[] headers = this.headers(name);
        return headers != null && headers.length > 0 ? headers[0] : null;
    }

    public Response content(byte[] bytes) {
        this.content = new ByteArrayInputStream(bytes);
        this.contentBytes = bytes;
        return this;
    }

    @Override
    public byte[] asBytes() {
        try {
            if (this.contentBytes != null) {
                return this.contentBytes;
            }
            this.contentBytes = SimpleHttp.cache(this.content);
            return this.contentBytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String asString() {
        return new String(this.asBytes(), UTF_8);
    }

    @Override
    public IResponse save(File file) throws IOException {
        if (this.content == null) {
            throw new IllegalStateException("Content is null, reject saving");
        }
        return this.save(new FileOutputStream(file));
    }

    @Override
    public IResponse save(OutputStream os) throws IOException {
        if (this.content == null) {
            throw new IllegalStateException("Content is null, reject saving");
        }
        SimpleHttp.copyStream(this.content, os);
        os.close();
        return this;
    }
}

