/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.damask.internal.job;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import pw.prok.damask.Damask;
import pw.prok.damask.dsl.IRepository;
import pw.prok.damask.internal.job.DamaskRequest;
import pw.prok.damask.internal.job.DamaskResult;
import pw.prok.damask.internal.job.ResultMerger;

public class DamaskExecutor<Request extends DamaskRequest<Result>, Result extends DamaskResult<Result>>
implements Runnable {
    private static Executor sExecutor = Executors.newFixedThreadPool(5, new ThreadFactory(){
        private int executorId = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = Executors.defaultThreadFactory().newThread(runnable);
            t.setName("Damask Executor #" + this.executorId++);
            t.setDaemon(true);
            return t;
        }
    });
    private final Request mRequest;
    private final Damask mDamask;
    private final ResultMerger<Result> mMerger;
    private final IRepository mRepository;

    public DamaskExecutor(Request request, Damask damask, ResultMerger<Result> merger, IRepository repository) {
        this.mRequest = request;
        this.mDamask = damask;
        this.mMerger = merger;
        this.mRepository = repository;
    }

    public static <Request extends DamaskRequest<Result>, Result extends DamaskResult<Result>> Result execute(Request request, Damask damask) {
        List<IRepository> repositories = damask.repositories();
        ResultMerger merger = new ResultMerger(repositories.size());
        for (IRepository repository : repositories) {
            sExecutor.execute(new DamaskExecutor(request, damask, merger, repository));
        }
        while (!merger.ready()) {
            Thread.yield();
        }
        return merger.result();
    }

    @Override
    public void run() {
        try {
            this.mMerger.addResult(((DamaskRequest)this.mRequest).performRequest(this.mDamask, this.mRepository));
        }
        catch (Exception e) {
            if ("true".equals(System.getProperty("damask.verbose"))) {
                e.printStackTrace();
            }
        }
        finally {
            this.mMerger.tick();
        }
    }
}

