/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import io.github.waterfallmc.waterfall.event.ProxyDefineCommandsEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.unix.DomainSocketAddress;
import java.io.DataInput;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerDisconnectEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.event.TabCompleteResponseEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.score.Objective;
import net.md_5.bungee.api.score.Position;
import net.md_5.bungee.api.score.Score;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.entitymap.EntityMap;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.Commands;
import net.md_5.bungee.protocol.packet.EntityEffect;
import net.md_5.bungee.protocol.packet.EntityRemoveEffect;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.tab.TabList;

public class DownstreamBridge
extends PacketHandler {
    private final ProxyServer bungee;
    private final UserConnection con;
    private final ServerConnection server;

    @Override
    public void exception(Throwable t) throws Exception {
        if (this.server.isObsolete()) {
            return;
        }
        ServerInfo def = this.con.updateAndGetNextServer(this.server.getInfo());
        ServerKickEvent event = this.bungee.getPluginManager().callEvent(new ServerKickEvent(this.con, this.server.getInfo(), TextComponent.fromLegacyText(this.bungee.getTranslation("server_went_down", new Object[0])), def, ServerKickEvent.State.CONNECTED, ServerKickEvent.Cause.EXCEPTION));
        if (event.isCancelled() && event.getCancelServer() != null) {
            this.server.setObsolete(true);
            this.con.connectNow(event.getCancelServer(), ServerConnectEvent.Reason.SERVER_DOWN_REDIRECT);
        } else {
            this.con.disconnect0(event.getKickReasonComponent());
        }
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        this.server.getInfo().removePlayer(this.con);
        if (this.bungee.getReconnectHandler() != null) {
            this.bungee.getReconnectHandler().setServer(this.con);
        }
        if (!this.server.isObsolete()) {
            ServerInfo def = this.con.updateAndGetNextServer(this.server.getInfo());
            ServerKickEvent event = this.bungee.getPluginManager().callEvent(new ServerKickEvent(this.con, this.server.getInfo(), TextComponent.fromLegacyText(this.bungee.getTranslation("lost_connection", new Object[0])), def, ServerKickEvent.State.CONNECTED, ServerKickEvent.Cause.LOST_CONNECTION));
            if (event.isCancelled() && event.getCancelServer() != null) {
                this.server.setObsolete(true);
                this.con.connectNow(event.getCancelServer());
            } else {
                this.con.disconnect0(event.getKickReasonComponent());
            }
        }
        ServerDisconnectEvent serverDisconnectEvent = new ServerDisconnectEvent(this.con, this.server.getInfo());
        this.bungee.getPluginManager().callEvent(serverDisconnectEvent);
    }

    @Override
    public boolean shouldHandle(PacketWrapper packet) throws Exception {
        return !this.server.isObsolete();
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        EntityMap rewrite = this.con.getEntityRewrite();
        if (rewrite != null) {
            rewrite.rewriteClientbound(packet.buf, this.con.getServerEntityId(), this.con.getClientEntityId(), this.con.getPendingConnection().getVersion());
        }
        this.con.sendPacket(packet);
    }

    @Override
    public void handle(KeepAlive alive) throws Exception {
        int timeout = this.bungee.getConfig().getTimeout();
        if (timeout <= 0 || this.server.getKeepAlives().size() < timeout / 50) {
            this.server.getKeepAlives().add(new ServerConnection.KeepAliveData(alive.getRandomId(), System.currentTimeMillis()));
        }
    }

    @Override
    public void handle(PlayerListItem playerList) throws Exception {
        boolean skipRewrites = this.bungee.getConfig().isDisableTabListRewrite();
        this.con.getTabListHandler().onUpdate(skipRewrites ? playerList : TabList.rewrite(playerList));
        if (!skipRewrites) {
            throw CancelSendSignal.INSTANCE;
        }
    }

    @Override
    public void handle(ScoreboardObjective objective) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        switch (objective.getAction()) {
            case 0: {
                serverScoreboard.addObjective(new Objective(objective.getName(), objective.getValue(), objective.getType() != null ? objective.getType().toString() : null));
                break;
            }
            case 1: {
                serverScoreboard.removeObjective(objective.getName());
                break;
            }
            case 2: {
                Objective oldObjective = serverScoreboard.getObjective(objective.getName());
                if (oldObjective == null) break;
                oldObjective.setValue(objective.getValue());
                oldObjective.setType(objective.getType() != null ? objective.getType().toString() : null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown objective action: " + objective.getAction());
            }
        }
    }

    @Override
    public void handle(ScoreboardScore score) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        switch (score.getAction()) {
            case 0: {
                Score s = new Score(score.getItemName(), score.getScoreName(), score.getValue());
                serverScoreboard.removeScore(score.getItemName());
                serverScoreboard.addScore(s);
                break;
            }
            case 1: {
                serverScoreboard.removeScore(score.getItemName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown scoreboard action: " + score.getAction());
            }
        }
    }

    @Override
    public void handle(ScoreboardDisplay displayScoreboard) throws Exception {
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        serverScoreboard.setName(displayScoreboard.getName());
        serverScoreboard.setPosition(Position.values()[displayScoreboard.getPosition()]);
    }

    @Override
    public void handle(Team team) throws Exception {
        net.md_5.bungee.api.score.Team t;
        Scoreboard serverScoreboard = this.con.getServerSentScoreboard();
        if (team.getMode() == 1) {
            serverScoreboard.removeTeam(team.getName());
            return;
        }
        if (team.getMode() == 0) {
            t = new net.md_5.bungee.api.score.Team(team.getName());
            serverScoreboard.addTeam(t);
        } else {
            t = serverScoreboard.getTeam(team.getName());
        }
        if (t != null) {
            if (team.getMode() == 0 || team.getMode() == 2) {
                t.setDisplayName(team.getDisplayName());
                t.setPrefix(team.getPrefix());
                t.setSuffix(team.getSuffix());
                t.setFriendlyFire(team.getFriendlyFire());
                t.setNameTagVisibility(team.getNameTagVisibility());
                t.setCollisionRule(team.getCollisionRule());
                t.setColor(team.getColor());
            }
            if (team.getPlayers() != null) {
                for (String s : team.getPlayers()) {
                    if (team.getMode() == 0 || team.getMode() == 3) {
                        t.addPlayer(s);
                        continue;
                    }
                    if (team.getMode() != 4) continue;
                    t.removePlayer(s);
                }
            }
        }
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        PluginMessageEvent event = new PluginMessageEvent(this.server, this.con, pluginMessage.getTag(), (byte[])pluginMessage.getData().clone());
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            throw CancelSendSignal.INSTANCE;
        }
        if (pluginMessage.getTag().equals(this.con.getPendingConnection().getVersion() >= 393 ? "minecraft:brand" : "MC|Brand")) {
            if (ProtocolConstants.isAfterOrEq(this.con.getPendingConnection().getVersion(), 47)) {
                try {
                    ByteBuf brand = Unpooled.wrappedBuffer(pluginMessage.getData());
                    String serverBrand = DefinedPacket.readString(brand);
                    brand.release();
                    brand = ByteBufAllocator.DEFAULT.heapBuffer();
                    DefinedPacket.writeString(this.bungee.getName() + " <- " + serverBrand, brand);
                    pluginMessage.setData(brand);
                    brand.release();
                }
                catch (Exception ProtocolHacksSuck) {
                    return;
                }
            } else {
                String serverBrand = new String(pluginMessage.getData(), StandardCharsets.UTF_8);
                pluginMessage.setData((this.bungee.getName() + " <- " + serverBrand).getBytes(StandardCharsets.UTF_8));
            }
            this.con.unsafe().sendPacket(pluginMessage);
            throw CancelSendSignal.INSTANCE;
        }
        if (pluginMessage.getTag().equals("BungeeCord")) {
            byte[] b;
            ServerInfo info;
            BaseComponent[] message;
            ServerInfo server;
            ProxiedPlayer player;
            ServerInfo server2;
            byte[] payload;
            byte[] data;
            short len;
            String channel;
            Object target;
            DataInput in = pluginMessage.getStream();
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            String subChannel = in.readUTF();
            if (subChannel.equals("ForwardToPlayer")) {
                target = this.bungee.getPlayer(in.readUTF());
                if (target != null) {
                    channel = in.readUTF();
                    len = in.readShort();
                    data = new byte[len];
                    in.readFully(data);
                    out.writeUTF(channel);
                    out.writeShort(data.length);
                    out.write(data);
                    payload = out.toByteArray();
                    target.getServer().sendData("BungeeCord", payload);
                }
                out = null;
            }
            if (subChannel.equals("Forward")) {
                target = in.readUTF();
                channel = in.readUTF();
                len = in.readShort();
                data = new byte[len];
                in.readFully(data);
                out.writeUTF(channel);
                out.writeShort(data.length);
                out.write(data);
                payload = out.toByteArray();
                out = null;
                if (((String)target).equals("ALL")) {
                    for (ServerInfo server3 : this.bungee.getServers().values()) {
                        if (server3 == this.server.getInfo()) continue;
                        server3.sendData("BungeeCord", payload);
                    }
                } else if (((String)target).equals("ONLINE")) {
                    for (ServerInfo server3 : this.bungee.getServers().values()) {
                        if (server3 == this.server.getInfo()) continue;
                        server3.sendData("BungeeCord", payload, false);
                    }
                } else {
                    ServerInfo server4 = this.bungee.getServerInfo((String)target);
                    if (server4 != null) {
                        server4.sendData("BungeeCord", payload);
                    }
                }
            }
            if (subChannel.equals("Connect") && (server2 = this.bungee.getServerInfo(in.readUTF())) != null) {
                this.con.connect(server2, ServerConnectEvent.Reason.PLUGIN_MESSAGE);
            }
            if (subChannel.equals("ConnectOther") && (player = this.bungee.getPlayer(in.readUTF())) != null && (server = this.bungee.getServerInfo(in.readUTF())) != null) {
                player.connect(server);
            }
            if (subChannel.equals("IP")) {
                out.writeUTF("IP");
                if (this.con.getSocketAddress() instanceof InetSocketAddress) {
                    out.writeUTF(this.con.getAddress().getHostString());
                    out.writeInt(this.con.getAddress().getPort());
                } else {
                    out.writeUTF("unix://" + ((DomainSocketAddress)this.con.getSocketAddress()).path());
                    out.writeInt(0);
                }
            }
            if (subChannel.equals("IPOther") && (player = this.bungee.getPlayer(in.readUTF())) != null) {
                out.writeUTF("IPOther");
                out.writeUTF(player.getName());
                if (player.getSocketAddress() instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)player.getSocketAddress();
                    out.writeUTF(address.getHostString());
                    out.writeInt(address.getPort());
                } else {
                    out.writeUTF("unix://" + ((DomainSocketAddress)player.getSocketAddress()).path());
                    out.writeInt(0);
                }
            }
            if (subChannel.equals("PlayerCount")) {
                target = in.readUTF();
                out.writeUTF("PlayerCount");
                if (((String)target).equals("ALL")) {
                    out.writeUTF("ALL");
                    out.writeInt(this.bungee.getOnlineCount());
                } else {
                    server = this.bungee.getServerInfo((String)target);
                    if (server != null) {
                        out.writeUTF(server.getName());
                        out.writeInt(server.getPlayers().size());
                    }
                }
            }
            if (subChannel.equals("PlayerList")) {
                target = in.readUTF();
                out.writeUTF("PlayerList");
                if (((String)target).equals("ALL")) {
                    out.writeUTF("ALL");
                    out.writeUTF(Util.csv(this.bungee.getPlayers()));
                } else {
                    server = this.bungee.getServerInfo((String)target);
                    if (server != null) {
                        out.writeUTF(server.getName());
                        out.writeUTF(Util.csv(server.getPlayers()));
                    }
                }
            }
            if (subChannel.equals("GetServers")) {
                out.writeUTF("GetServers");
                out.writeUTF(Util.csv(this.bungee.getServers().keySet()));
            }
            if (subChannel.equals("Message")) {
                target = in.readUTF();
                message = in.readUTF();
                if (((String)target).equals("ALL")) {
                    for (ProxiedPlayer player2 : this.bungee.getPlayers()) {
                        player2.sendMessage((String)message);
                    }
                } else {
                    ProxiedPlayer player3 = this.bungee.getPlayer((String)target);
                    if (player3 != null) {
                        player3.sendMessage((String)message);
                    }
                }
            }
            if (subChannel.equals("MessageRaw")) {
                target = in.readUTF();
                message = ComponentSerializer.parse(in.readUTF());
                if (((String)target).equals("ALL")) {
                    for (ProxiedPlayer player2 : this.bungee.getPlayers()) {
                        player2.sendMessage(message);
                    }
                } else {
                    ProxiedPlayer player4 = this.bungee.getPlayer((String)target);
                    if (player4 != null) {
                        player4.sendMessage(message);
                    }
                }
            }
            if (subChannel.equals("GetServer")) {
                out.writeUTF("GetServer");
                out.writeUTF(this.server.getInfo().getName());
            }
            if (subChannel.equals("UUID")) {
                out.writeUTF("UUID");
                out.writeUTF(this.con.getUUID());
            }
            if (subChannel.equals("UUIDOther") && (player = this.bungee.getPlayer(in.readUTF())) != null) {
                out.writeUTF("UUIDOther");
                out.writeUTF(player.getName());
                out.writeUTF(player.getUUID());
            }
            if (subChannel.equals("ServerIP") && (info = this.bungee.getServerInfo(in.readUTF())) != null && !info.getAddress().isUnresolved()) {
                out.writeUTF("ServerIP");
                out.writeUTF(info.getName());
                out.writeUTF(info.getAddress().getAddress().getHostAddress());
                out.writeShort(info.getAddress().getPort());
            }
            if (subChannel.equals("KickPlayer") && (player = this.bungee.getPlayer(in.readUTF())) != null) {
                String kickReason = in.readUTF();
                player.disconnect((BaseComponent)new TextComponent(kickReason));
            }
            if (out != null && (b = out.toByteArray()).length != 0) {
                this.server.sendData("BungeeCord", b);
            }
            throw CancelSendSignal.INSTANCE;
        }
    }

    @Override
    public void handle(Kick kick) throws Exception {
        ServerKickEvent event;
        ServerInfo def = this.con.updateAndGetNextServer(this.server.getInfo());
        if (Objects.equals(this.server.getInfo(), def)) {
            def = null;
        }
        if ((event = this.bungee.getPluginManager().callEvent(new ServerKickEvent(this.con, this.server.getInfo(), ComponentSerializer.parse(kick.getMessage()), def, ServerKickEvent.State.CONNECTED, ServerKickEvent.Cause.SERVER))).isCancelled() && event.getCancelServer() != null) {
            this.con.connectNow(event.getCancelServer(), ServerConnectEvent.Reason.KICK_REDIRECT);
        } else {
            this.con.disconnect0(event.getKickReasonComponent());
        }
        this.server.setObsolete(true);
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(SetCompression setCompression) throws Exception {
        this.server.getCh().setCompressionThreshold(setCompression.getThreshold());
    }

    @Override
    public void handle(TabCompleteResponse tabCompleteResponse) throws Exception {
        List<String> commands = tabCompleteResponse.getCommands();
        if (commands == null) {
            commands = Lists.transform(tabCompleteResponse.getSuggestions().getList(), new Function<Suggestion, String>(){

                @Override
                public String apply(Suggestion input) {
                    return input.getText();
                }
            });
        }
        TabCompleteResponseEvent tabCompleteResponseEvent = new TabCompleteResponseEvent(this.server, this.con, new ArrayList<String>(commands));
        if (!this.bungee.getPluginManager().callEvent(tabCompleteResponseEvent).isCancelled()) {
            if (!commands.equals(tabCompleteResponseEvent.getSuggestions())) {
                if (tabCompleteResponse.getCommands() != null) {
                    tabCompleteResponse.setCommands(tabCompleteResponseEvent.getSuggestions());
                } else {
                    final StringRange range = tabCompleteResponse.getSuggestions().getRange();
                    tabCompleteResponse.setSuggestions(new Suggestions(range, Lists.transform(tabCompleteResponseEvent.getSuggestions(), new Function<String, Suggestion>(){

                        @Override
                        public Suggestion apply(String input) {
                            return new Suggestion(range, input);
                        }
                    })));
                }
            }
            this.con.unsafe().sendPacket(tabCompleteResponse);
        }
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(BossBar bossBar) {
        switch (bossBar.getAction()) {
            case 0: {
                this.con.getSentBossBars().add(bossBar.getUuid());
                break;
            }
            case 1: {
                this.con.getSentBossBars().remove(bossBar.getUuid());
            }
        }
    }

    @Override
    public void handle(EntityEffect entityEffect) throws Exception {
        if (this.con.isDisableEntityMetadataRewrite()) {
            return;
        }
        if (this.con.getForgeClientHandler().isForgeUser() && !this.con.getForgeClientHandler().isHandshakeComplete()) {
            throw CancelSendSignal.INSTANCE;
        }
        this.con.getPotions().put(this.rewriteEntityId(entityEffect.getEntityId()), entityEffect.getEffectId());
    }

    @Override
    public void handle(EntityRemoveEffect removeEffect) throws Exception {
        if (this.con.isDisableEntityMetadataRewrite()) {
            return;
        }
        this.con.getPotions().remove(this.rewriteEntityId(removeEffect.getEntityId()), removeEffect.getEffectId());
    }

    private int rewriteEntityId(int entityId) {
        if (entityId == this.con.getServerEntityId()) {
            return this.con.getClientEntityId();
        }
        return entityId;
    }

    @Override
    public void handle(Respawn respawn) {
        this.con.setDimension(respawn.getDimension());
    }

    @Override
    public void handle(Commands commands) throws Exception {
        boolean modified = false;
        HashMap<String, Command> commandMap = new HashMap<String, Command>();
        for (Map.Entry<String, Command> commandEntry : this.bungee.getPluginManager().getCommands()) {
            if (this.bungee.getDisabledCommands().contains(commandEntry.getKey()) || commands.getRoot().getChild(commandEntry.getKey()) != null || !commandEntry.getValue().hasPermission(this.con)) continue;
            commandMap.put(commandEntry.getKey(), commandEntry.getValue());
        }
        ProxyDefineCommandsEvent event = new ProxyDefineCommandsEvent(this.server, this.con, commandMap);
        this.bungee.getPluginManager().callEvent(event);
        for (Map.Entry<String, Command> command : event.getCommands().entrySet()) {
            CommandNode dummy = ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(command.getKey()).then(RequiredArgumentBuilder.argument("args", StringArgumentType.greedyString()).suggests(Commands.SuggestionRegistry.ASK_SERVER))).build();
            commands.getRoot().addChild(dummy);
            modified = true;
        }
        if (modified) {
            this.con.unsafe().sendPacket(commands);
            throw CancelSendSignal.INSTANCE;
        }
    }

    @Override
    public String toString() {
        return "[" + this.con.getAddress() + "|" + this.con.getName() + "] <-> DownstreamBridge <-> [" + this.server.getInfo().getName() + "]";
    }

    public DownstreamBridge(ProxyServer bungee, UserConnection con, ServerConnection server) {
        this.bungee = bungee;
        this.con = con;
        this.server = server;
    }
}

