/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.event;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.event.EventExceptionHandler;
import net.md_5.bungee.event.EventHandler;
import net.md_5.bungee.event.EventHandlerMethod;

public class EventBus {
    private final Map<Class<?>, Map<Byte, Map<Object, Method[]>>> byListenerAndPriority = new HashMap();
    private final Map<Class<?>, EventHandlerMethod[]> byEventBaked = new ConcurrentHashMap();
    private final Lock lock = new ReentrantLock();
    private final Logger logger;

    public EventBus() {
        this(null);
    }

    public EventBus(Logger logger) {
        this.logger = logger == null ? Logger.getLogger("global") : logger;
    }

    public <T> void post(T event, EventExceptionHandler<T> exceptionHandler) {
        EventHandlerMethod[] handlers = this.byEventBaked.get(event.getClass());
        if (handlers != null) {
            for (EventHandlerMethod method : handlers) {
                try {
                    method.invoke(event);
                }
                catch (IllegalAccessException ex) {
                    throw new Error("Method became inaccessible: " + event, ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new Error("Method rejected target/argument: " + event, ex);
                }
                catch (InvocationTargetException ex) {
                    String msg = MessageFormat.format("Error dispatching event {0} to listener {1}", event, method.getListener());
                    this.logger.log(Level.WARNING, msg, ex.getCause());
                    if (exceptionHandler == null) continue;
                    exceptionHandler.handleEventException(msg, event, method, ex);
                }
            }
        }
    }

    private Map<Class<?>, Map<Byte, Set<Method>>> findHandlers(Object listener) {
        HashMap handler = new HashMap();
        ImmutableCollection methods = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(listener.getClass().getMethods())).add(listener.getClass().getDeclaredMethods())).build();
        for (Method m : methods) {
            HashSet<Method> priority;
            EventHandler annotation = m.getAnnotation(EventHandler.class);
            if (annotation == null) continue;
            Class<?>[] params = m.getParameterTypes();
            if (params.length != 1) {
                this.logger.log(Level.INFO, "Method {0} in class {1} annotated with {2} does not have single argument", new Object[]{m, listener.getClass(), annotation});
                continue;
            }
            HashMap<Byte, HashSet<Method>> prioritiesMap = (HashMap<Byte, HashSet<Method>>)handler.get(params[0]);
            if (prioritiesMap == null) {
                prioritiesMap = new HashMap<Byte, HashSet<Method>>();
                handler.put(params[0], prioritiesMap);
            }
            if ((priority = (HashSet<Method>)prioritiesMap.get(annotation.priority())) == null) {
                priority = new HashSet<Method>();
                prioritiesMap.put(annotation.priority(), priority);
            }
            priority.add(m);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object listener) {
        Map<Class<?>, Map<Byte, Set<Method>>> handler = this.findHandlers(listener);
        this.lock.lock();
        try {
            for (Map.Entry<Class<?>, Map<Byte, Set<Method>>> e : handler.entrySet()) {
                Map<Byte, Map<Object, Method[]>> prioritiesMap = this.byListenerAndPriority.get(e.getKey());
                if (prioritiesMap == null) {
                    prioritiesMap = new HashMap<Byte, Map<Object, Method[]>>();
                    this.byListenerAndPriority.put(e.getKey(), prioritiesMap);
                }
                for (Map.Entry<Byte, Set<Method>> entry : e.getValue().entrySet()) {
                    Map<Object, Method[]> currentPriorityMap = prioritiesMap.get(entry.getKey());
                    if (currentPriorityMap == null) {
                        currentPriorityMap = new HashMap<Object, Method[]>();
                        prioritiesMap.put(entry.getKey(), currentPriorityMap);
                    }
                    currentPriorityMap.put(listener, entry.getValue().toArray(new Method[0]));
                }
                this.bakeHandlers(e.getKey());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Object listener) {
        Map<Class<?>, Map<Byte, Set<Method>>> handler = this.findHandlers(listener);
        this.lock.lock();
        try {
            for (Map.Entry<Class<?>, Map<Byte, Set<Method>>> e : handler.entrySet()) {
                Map<Byte, Map<Object, Method[]>> prioritiesMap = this.byListenerAndPriority.get(e.getKey());
                if (prioritiesMap != null) {
                    for (Byte priority : e.getValue().keySet()) {
                        Map<Object, Method[]> currentPriority = prioritiesMap.get(priority);
                        if (currentPriority == null) continue;
                        currentPriority.remove(listener);
                        if (!currentPriority.isEmpty()) continue;
                        prioritiesMap.remove(priority);
                    }
                    if (prioritiesMap.isEmpty()) {
                        this.byListenerAndPriority.remove(e.getKey());
                    }
                }
                this.bakeHandlers(e.getKey());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void bakeHandlers(Class<?> eventClass) {
        Map<Byte, Map<Object, Method[]>> handlersByPriority = this.byListenerAndPriority.get(eventClass);
        if (handlersByPriority != null) {
            byte by;
            ArrayList<EventHandlerMethod> handlersList = new ArrayList<EventHandlerMethod>(handlersByPriority.size() * 2);
            byte value = -128;
            do {
                Map<Object, Method[]> handlersByListener;
                if ((handlersByListener = handlersByPriority.get(value)) != null) {
                    for (Map.Entry<Object, Method[]> listenerHandlers : handlersByListener.entrySet()) {
                        for (Method method : listenerHandlers.getValue()) {
                            EventHandlerMethod ehm = new EventHandlerMethod(listenerHandlers.getKey(), method);
                            handlersList.add(ehm);
                        }
                    }
                }
                by = value;
                value = (byte)(value + 1);
            } while (by < 127);
            this.byEventBaked.put(eventClass, handlersList.toArray(new EventHandlerMethod[0]));
        } else {
            this.byEventBaked.remove(eventClass);
        }
    }
}

