/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.ChunkSection;
import net.minecraft.server.v1_12_R1.NibbleArray;
import net.minecraft.server.v1_12_R1.WorldChunkManager;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_12_R1.CraftChunkSnapshot;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlock;
import org.bukkit.entity.Entity;

public class CraftChunk
implements Chunk {
    private WeakReference<net.minecraft.server.v1_12_R1.Chunk> weakChunk;
    private final WorldServer worldServer;
    private final int x;
    private final int z;
    private static final byte[] emptyData = new byte[2048];
    private static final short[] emptyBlockIDs = new short[4096];
    private static final byte[] emptySkyLight = new byte[2048];

    static {
        Arrays.fill(emptySkyLight, (byte)-1);
    }

    public CraftChunk(net.minecraft.server.v1_12_R1.Chunk chunk) {
        this.weakChunk = new WeakReference<net.minecraft.server.v1_12_R1.Chunk>(chunk);
        this.worldServer = (WorldServer)this.getHandle().world;
        this.x = this.getHandle().locX;
        this.z = this.getHandle().locZ;
    }

    @Override
    public World getWorld() {
        return this.worldServer.getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public net.minecraft.server.v1_12_R1.Chunk getHandle() {
        net.minecraft.server.v1_12_R1.Chunk c = (net.minecraft.server.v1_12_R1.Chunk)this.weakChunk.get();
        if (c == null) {
            c = this.worldServer.getChunkAt(this.x, this.z);
            this.weakChunk = new WeakReference<net.minecraft.server.v1_12_R1.Chunk>(c);
        }
        return c;
    }

    void breakLink() {
        this.weakChunk.clear();
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "CraftChunk{x=" + this.getX() + "z=" + this.getZ() + '}';
    }

    @Override
    public Block getBlock(int x, int y, int z) {
        return new CraftBlock(this, this.getX() << 4 | x & 0xF, y, this.getZ() << 4 | z & 0xF);
    }

    @Override
    public Entity[] getEntities() {
        int count = 0;
        int index = 0;
        net.minecraft.server.v1_12_R1.Chunk chunk = this.getHandle();
        int i = 0;
        while (i < 16) {
            count += chunk.entitySlices[i].size();
            ++i;
        }
        Entity[] entities = new Entity[count];
        int i2 = 0;
        while (i2 < 16) {
            Object[] objectArray = chunk.entitySlices[i2].toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof net.minecraft.server.v1_12_R1.Entity) {
                    entities[index++] = ((net.minecraft.server.v1_12_R1.Entity)obj).getBukkitEntity();
                }
                ++n2;
            }
            ++i2;
        }
        return entities;
    }

    @Override
    public BlockState[] getTileEntities() {
        int index = 0;
        net.minecraft.server.v1_12_R1.Chunk chunk = this.getHandle();
        BlockState[] entities = new BlockState[chunk.tileEntities.size()];
        Object[] objectArray = chunk.tileEntities.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof BlockPosition) {
                BlockPosition position = (BlockPosition)obj;
                entities[index++] = this.worldServer.getWorld().getBlockAt(position.getX(), position.getY(), position.getZ()).getState();
            }
            ++n2;
        }
        return entities;
    }

    @Override
    public boolean isLoaded() {
        return this.getWorld().isChunkLoaded(this);
    }

    @Override
    public boolean load() {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), true);
    }

    @Override
    public boolean load(boolean generate) {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), generate);
    }

    @Override
    public boolean unload() {
        return this.getWorld().unloadChunk(this.getX(), this.getZ());
    }

    @Override
    public boolean isSlimeChunk() {
        return this.getHandle().a((long)this.worldServer.spigotConfig.slimeSeed).nextInt(10) == 0;
    }

    @Override
    public boolean unload(boolean save) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save);
    }

    @Override
    public boolean unload(boolean save, boolean safe) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save, safe);
    }

    @Override
    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    @Override
    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain) {
        net.minecraft.server.v1_12_R1.Chunk chunk = this.getHandle();
        ChunkSection[] cs = chunk.getSections();
        short[][] sectionBlockIDs = new short[cs.length][];
        byte[][] sectionBlockData = new byte[cs.length][];
        byte[][] sectionSkyLights = new byte[cs.length][];
        byte[][] sectionEmitLights = new byte[cs.length][];
        boolean[] sectionEmpty = new boolean[cs.length];
        int i = 0;
        while (i < cs.length) {
            if (cs[i] == null) {
                sectionBlockIDs[i] = emptyBlockIDs;
                sectionBlockData[i] = emptyData;
                sectionSkyLights[i] = emptySkyLight;
                sectionEmitLights[i] = emptyData;
                sectionEmpty[i] = true;
            } else {
                short[] blockids = new short[4096];
                byte[] rawIds = new byte[4096];
                NibbleArray data = new NibbleArray();
                cs[i].getBlocks().exportData(rawIds, data);
                sectionBlockData[i] = data.asBytes();
                int j = 0;
                while (j < 4096) {
                    blockids[j] = (short)(rawIds[j] & 0xFF);
                    ++j;
                }
                sectionBlockIDs[i] = blockids;
                if (cs[i].getSkyLightArray() == null) {
                    sectionSkyLights[i] = emptyData;
                } else {
                    sectionSkyLights[i] = new byte[2048];
                    System.arraycopy(cs[i].getSkyLightArray().asBytes(), 0, sectionSkyLights[i], 0, 2048);
                }
                sectionEmitLights[i] = new byte[2048];
                System.arraycopy(cs[i].getEmittedLightArray().asBytes(), 0, sectionEmitLights[i], 0, 2048);
            }
            ++i;
        }
        int[] hmap = null;
        if (includeMaxBlockY) {
            hmap = new int[256];
            System.arraycopy(chunk.heightMap, 0, hmap, 0, 256);
        }
        BiomeBase[] biome = null;
        double[] biomeTemp = null;
        double[] biomeRain = null;
        if (includeBiome || includeBiomeTempRain) {
            WorldChunkManager wcm = chunk.world.getWorldChunkManager();
            if (includeBiome) {
                biome = new BiomeBase[256];
                int i2 = 0;
                while (i2 < 256) {
                    biome[i2] = chunk.getBiome(new BlockPosition(i2 & 0xF, 0, i2 >> 4), wcm);
                    ++i2;
                }
            }
            if (includeBiomeTempRain) {
                biomeTemp = new double[256];
                biomeRain = new double[256];
                float[] dat = CraftChunk.getTemperatures(wcm, this.getX() << 4, this.getZ() << 4);
                int i3 = 0;
                while (i3 < 256) {
                    biomeTemp[i3] = dat[i3];
                    ++i3;
                }
            }
        }
        World world = this.getWorld();
        return new CraftChunkSnapshot(this.getX(), this.getZ(), world.getName(), world.getFullTime(), sectionBlockIDs, sectionBlockData, sectionSkyLights, sectionEmitLights, sectionEmpty, hmap, biome, biomeTemp, biomeRain);
    }

    public static ChunkSnapshot getEmptyChunkSnapshot(int x, int z, CraftWorld world, boolean includeBiome, boolean includeBiomeTempRain) {
        BiomeBase[] biome = null;
        double[] biomeTemp = null;
        double[] biomeRain = null;
        if (includeBiome || includeBiomeTempRain) {
            WorldChunkManager wcm = world.getHandle().getWorldChunkManager();
            if (includeBiome) {
                biome = new BiomeBase[256];
                int i = 0;
                while (i < 256) {
                    biome[i] = world.getHandle().getBiome(new BlockPosition((x << 4) + (i & 0xF), 0, (z << 4) + (i >> 4)));
                    ++i;
                }
            }
            if (includeBiomeTempRain) {
                biomeTemp = new double[256];
                biomeRain = new double[256];
                float[] dat = CraftChunk.getTemperatures(wcm, x << 4, z << 4);
                int i = 0;
                while (i < 256) {
                    biomeTemp[i] = dat[i];
                    ++i;
                }
            }
        }
        int hSection = world.getMaxHeight() >> 4;
        short[][] blockIDs = new short[hSection][];
        byte[][] skyLight = new byte[hSection][];
        byte[][] emitLight = new byte[hSection][];
        byte[][] blockData = new byte[hSection][];
        boolean[] empty = new boolean[hSection];
        int i = 0;
        while (i < hSection) {
            blockIDs[i] = emptyBlockIDs;
            skyLight[i] = emptySkyLight;
            emitLight[i] = emptyData;
            blockData[i] = emptyData;
            empty[i] = true;
            ++i;
        }
        return new CraftChunkSnapshot(x, z, world.getName(), world.getFullTime(), blockIDs, blockData, skyLight, emitLight, empty, new int[256], biome, biomeTemp, biomeRain);
    }

    private static float[] getTemperatures(WorldChunkManager chunkmanager, int chunkX, int chunkZ) {
        BiomeBase[] biomes = chunkmanager.getBiomes(null, chunkX, chunkZ, 16, 16);
        float[] temps = new float[biomes.length];
        int i = 0;
        while (i < biomes.length) {
            float temp = biomes[i].getTemperature();
            if (temp > 1.0f) {
                temp = 1.0f;
            }
            temps[i] = temp;
            ++i;
        }
        return temps;
    }
}

