/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.attribute;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.server.v1_12_R1.AttributeInstance;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;

public class CraftAttributeInstance
implements org.bukkit.attribute.AttributeInstance {
    private final AttributeInstance handle;
    private final Attribute attribute;

    public CraftAttributeInstance(AttributeInstance handle, Attribute attribute) {
        this.handle = handle;
        this.attribute = attribute;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public double getBaseValue() {
        return this.handle.b();
    }

    @Override
    public void setBaseValue(double d) {
        this.handle.setValue(d);
    }

    @Override
    public Collection<AttributeModifier> getModifiers() {
        ArrayList<AttributeModifier> result = new ArrayList<AttributeModifier>();
        for (net.minecraft.server.v1_12_R1.AttributeModifier nms : this.handle.c()) {
            result.add(CraftAttributeInstance.convert(nms));
        }
        return result;
    }

    @Override
    public void addModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.b(CraftAttributeInstance.convert(modifier));
    }

    @Override
    public void removeModifier(AttributeModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"modifier");
        this.handle.c(CraftAttributeInstance.convert(modifier));
    }

    @Override
    public double getValue() {
        return this.handle.getValue();
    }

    @Override
    public double getDefaultValue() {
        return this.handle.getAttribute().getDefault();
    }

    private static net.minecraft.server.v1_12_R1.AttributeModifier convert(AttributeModifier bukkit) {
        return new net.minecraft.server.v1_12_R1.AttributeModifier(bukkit.getUniqueId(), bukkit.getName(), bukkit.getAmount(), bukkit.getOperation().ordinal());
    }

    private static AttributeModifier convert(net.minecraft.server.v1_12_R1.AttributeModifier nms) {
        return new AttributeModifier(nms.a(), nms.b(), nms.d(), AttributeModifier.Operation.values()[nms.c()]);
    }
}

