/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.block;

import com.google.common.base.Preconditions;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import net.minecraft.server.v1_12_R1.TileEntityMobSpawner;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockEntityState;
import org.bukkit.entity.EntityType;

public class CraftCreatureSpawner
extends CraftBlockEntityState<TileEntityMobSpawner>
implements CreatureSpawner {
    public CraftCreatureSpawner(Block block) {
        super(block, TileEntityMobSpawner.class);
    }

    public CraftCreatureSpawner(Material material, TileEntityMobSpawner te) {
        super(material, te);
    }

    @Override
    public EntityType getSpawnedType() {
        MinecraftKey key = ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().getMobName();
        return key == null ? EntityType.PIG : EntityType.fromName(key.getKey());
    }

    @Override
    public void setSpawnedType(EntityType entityType) {
        if (entityType == null || entityType.getName() == null) {
            throw new IllegalArgumentException("Can't spawn EntityType " + (Object)((Object)entityType) + " from mobspawners!");
        }
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().setMobName(new MinecraftKey(entityType.getName()));
    }

    @Override
    public String getCreatureTypeName() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().getMobName().getKey();
    }

    @Override
    public void setCreatureTypeByName(String creatureType) {
        EntityType type = EntityType.fromName(creatureType);
        if (type == null) {
            return;
        }
        this.setSpawnedType(type);
    }

    @Override
    public int getDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnDelay;
    }

    @Override
    public void setDelay(int delay) {
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnDelay = delay;
    }

    @Override
    public int getMinSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().minSpawnDelay;
    }

    @Override
    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().minSpawnDelay = spawnDelay;
    }

    @Override
    public int getMaxSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().maxSpawnDelay;
    }

    @Override
    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().maxSpawnDelay = spawnDelay;
    }

    @Override
    public int getMaxNearbyEntities() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().maxNearbyEntities;
    }

    @Override
    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().maxNearbyEntities = maxNearbyEntities;
    }

    @Override
    public int getSpawnCount() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnCount;
    }

    @Override
    public void setSpawnCount(int count) {
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnCount = count;
    }

    @Override
    public int getRequiredPlayerRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().requiredPlayerRange;
    }

    @Override
    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().requiredPlayerRange = requiredPlayerRange;
    }

    @Override
    public int getSpawnRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnRange;
    }

    @Override
    public void setSpawnRange(int spawnRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).getSpawner().spawnRange = spawnRange;
    }
}

