/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.block;

import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.TileEntityNote;
import net.minecraft.server.v1_12_R1.World;
import org.bukkit.Instrument;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.block.Block;
import org.bukkit.block.NoteBlock;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftMagicNumbers;

public class CraftNoteBlock
extends CraftBlockEntityState<TileEntityNote>
implements NoteBlock {
    public CraftNoteBlock(Block block) {
        super(block, TileEntityNote.class);
    }

    public CraftNoteBlock(Material material, TileEntityNote te) {
        super(material, te);
    }

    @Override
    public Note getNote() {
        return new Note(((TileEntityNote)this.getSnapshot()).note);
    }

    @Override
    public byte getRawNote() {
        return ((TileEntityNote)this.getSnapshot()).note;
    }

    @Override
    public void setNote(Note note) {
        ((TileEntityNote)this.getSnapshot()).note = note.getId();
    }

    @Override
    public void setRawNote(byte note) {
        ((TileEntityNote)this.getSnapshot()).note = note;
    }

    @Override
    public boolean play() {
        Block block = this.getBlock();
        if (block.getType() == Material.NOTE_BLOCK) {
            TileEntityNote note = (TileEntityNote)this.getTileEntityFromWorld();
            CraftWorld world = (CraftWorld)this.getWorld();
            note.play((World)world.getHandle(), new BlockPosition(this.getX(), this.getY(), this.getZ()));
            return true;
        }
        return false;
    }

    @Override
    public boolean play(byte instrument, byte note) {
        Block block = this.getBlock();
        if (block.getType() == Material.NOTE_BLOCK) {
            CraftWorld world = (CraftWorld)this.getWorld();
            world.getHandle().playBlockAction(new BlockPosition(this.getX(), this.getY(), this.getZ()), CraftMagicNumbers.getBlock(block), (int)instrument, (int)note);
            return true;
        }
        return false;
    }

    @Override
    public boolean play(Instrument instrument, Note note) {
        Block block = this.getBlock();
        if (block.getType() == Material.NOTE_BLOCK) {
            CraftWorld world = (CraftWorld)this.getWorld();
            world.getHandle().playBlockAction(new BlockPosition(this.getX(), this.getY(), this.getZ()), CraftMagicNumbers.getBlock(block), (int)instrument.getType(), (int)note.getId());
            return true;
        }
        return false;
    }
}

