/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.chunkio;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.v1_12_R1.Chunk;
import net.minecraft.server.v1_12_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_12_R1.ChunkRegionLoader;
import net.minecraft.server.v1_12_R1.IChunkProvider;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import org.bukkit.craftbukkit.v1_12_R1.chunkio.QueuedChunk;
import org.bukkit.craftbukkit.v1_12_R1.util.AsynchronousExecutor;

class ChunkIOProvider
implements AsynchronousExecutor.CallBackProvider<QueuedChunk, Chunk, Runnable, RuntimeException> {
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    ChunkIOProvider() {
    }

    @Override
    public Chunk callStage1(QueuedChunk queuedChunk) throws RuntimeException {
        try {
            ChunkRegionLoader loader = queuedChunk.loader;
            Object[] data = loader.loadChunk(queuedChunk.world, queuedChunk.x, queuedChunk.z);
            if (data != null) {
                queuedChunk.compound = (NBTTagCompound)data[1];
                return (Chunk)data[0];
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void callStage2(QueuedChunk queuedChunk, Chunk chunk) throws RuntimeException {
        if (chunk == null) {
            queuedChunk.provider.originalGetChunkAt(queuedChunk.x, queuedChunk.z);
            return;
        }
        queuedChunk.loader.loadEntities(chunk, queuedChunk.compound.getCompound("Level"), queuedChunk.world);
        chunk.setLastSaved(queuedChunk.provider.world.getTime());
        queuedChunk.provider.chunks.put(ChunkCoordIntPair.a((int)queuedChunk.x, (int)queuedChunk.z), (Object)chunk);
        chunk.addEntities();
        if (queuedChunk.provider.chunkGenerator != null) {
            queuedChunk.provider.world.timings.syncChunkLoadStructuresTimer.startTiming();
            queuedChunk.provider.chunkGenerator.recreateStructures(chunk, queuedChunk.x, queuedChunk.z);
            queuedChunk.provider.world.timings.syncChunkLoadStructuresTimer.stopTiming();
        }
        chunk.loadNearby((IChunkProvider)queuedChunk.provider, queuedChunk.provider.chunkGenerator, false);
    }

    @Override
    public void callStage3(QueuedChunk queuedChunk, Chunk chunk, Runnable runnable) throws RuntimeException {
        runnable.run();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, "Chunk I/O Executor Thread-" + this.threadNumber.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    }
}

